#ifndef _LUAINITNPCS_H
#define _LUAINITNPCS_H

#include "Types.h"

//----- Start Legion 2 -----
#ifdef LEGION2
#include "legion cfg.h"

extern "C" {
#include "lua.h"
#include "lauxlib.h"
#include "lualib.h"
}

#endif
//----- End Legion 2 -----

typedef struct
{
	BOOLEAN	fGlobalLuaBool;
	UINT32	iGlobalLuaVal; 
} LUA_GLOBAL;

extern LUA_GLOBAL	gLuaGlobal[1000]; 


#define MAX_ACTION_NAMES_CHARS		30	

typedef struct
{
	UINT16 uiIndex;
	UINT8 ActionID;
	UINT32 BombItem;
	CHAR16	szName[MAX_ACTION_NAMES_CHARS];
	UINT8 BlowUp;

} ACTION_ITEM_VALUES;

extern ACTION_ITEM_VALUES ActionItemsValues[500];

extern UINT32 uiHourLua;
extern UINT32 uiDayLua;
extern UINT32 uiMinLua;
extern UINT16 PROFILLUA_sSectorX;
extern UINT16 PROFILLUA_sSectorY;
extern UINT8 PROFILLUA_bSectorZ;
extern UINT8 PROFILLUA_Level;
extern UINT8 PROFILLUA_ubID;
extern UINT32 PROFILLUA_sGridNo;
extern UINT8 PROFILLUA_ubDirectiono;
extern UINT8 PROFILLUA_bTeam;

extern UINT8  PROFILLUA2_ubProfile;
extern UINT16 PROFILLUA2_sSectorX;
extern UINT16 PROFILLUA2_sSectorY;
extern UINT8  PROFILLUA2_bSectorZ;
extern UINT8  PROFILLUA2_ubID;
extern UINT32 PROFILLUA2_sGridNo;

extern BOOLEAN LetHandleLoyaltyChangeForNPCAction(UINT8 ubNPCProfileId , UINT8 Init);
extern BOOLEAN LuaHandleGlobalLoyaltyEvent( UINT8 ubEventType, INT16 sSectorX, INT16 sSectorY, INT8 bSectorZ , UINT8 Init);
extern BOOLEAN LetLuaHandleEarlyMorningEvents(UINT8 Init);
extern BOOLEAN LetLuaHourlyQuestUpdate(UINT8 Init);
extern BOOLEAN LetLuaMyCustomHandleAtNewGridNo(UINT8 bNewSide, UINT8 ProfileId,  UINT8 Init);
extern BOOLEAN LetLuaPerformItemAction(UINT32 Action, INT32 sGridNo, UINT8 InitFunction);
extern BOOLEAN LetLuaGameInit(UINT8 Init);
extern BOOLEAN LetLuaInterfaceDialogue( UINT8 ubNPC, UINT8 InitFunction);
extern BOOLEAN LuaHandlePlayerTeamMemberDeath(UINT8 ProfileId, UINT8 Init);
extern BOOLEAN LuaHandleNPCTeamMemberDeath(UINT8 ProfileId, UINT8 Init);
extern BOOLEAN LuaCheckForKingpinsMoneyMissing( BOOLEAN fFirstCheck, UINT8 Init);
extern BOOLEAN LuaHandleQuestCodeOnSector( INT16 sSectorX, INT16 sSectorY, INT8 bSectorZ, UINT8 Init);
//extern BOOLEAN LuaHandleQuestCodeOnSectorEntry( INT16 sSectorX, INT16 sSectorY, INT8 bSectorZ, UINT8 Init);
extern BOOLEAN LuaHandleDelayedItemsArrival( UINT32 uiReason, UINT8 Init);
extern BOOLEAN LetLuaHandleNPCSystemEvent( UINT32 uiEvent, UINT8 Init);

extern BOOLEAN LuaCheckFact ( UINT16 usFact, UINT8 ubProfileID , UINT32 Init);
extern BOOLEAN LuaHandleNPCDoAction( UINT8 ubTargetNPC, UINT16 usActionCode, UINT8 ubQuoteNum , UINT8 InitFunction);

//----- Start Legion 2 -----
#ifdef LEGION2
extern BOOLEAN LuaInternalQuest( UINT8 ubQuest, INT16 sSectorX, INT16 sSectorY, BOOLEAN fUpdateHistory, UINT16 usFact, UINT8 ubProfileID, UINT32 Init);
#else
extern BOOLEAN LuaInternalQuest( UINT8 ubQuest, INT16 sSectorX, INT16 sSectorY, BOOLEAN fUpdateHistory, UINT32 Init);
#endif
//----- End Legion 2 -----

extern BOOLEAN LuaExecuteStrategicEvent( UINT8 EventCallbackID, UINT32 uiTimeStamp, UINT32 uiTimeOffset, UINT8	ubEventType, UINT8 ubFlags, UINT32 EventParam, UINT32 Init);

extern void IniLuaGlobal();

extern BOOLEAN LoadLuaGlobalFromLoadGameFile( HWFILE hFile );
extern BOOLEAN SaveLuaGlobalToSaveGameFile( HWFILE hFile );


#ifdef JA2UB
extern BOOLEAN LuaInitStrategicLayer(UINT8 Init);
extern BOOLEAN LetLuaMakeBadSectorListFromMapsOnHardDrive(UINT8 Init);
#endif

//Intro
extern BOOLEAN LuaIntro(UINT8 Init, UINT32 uiCurrentVideo, INT8 bIntroType, UINT32 iStringToUse);
extern BOOLEAN LuaIDScripts(UINT8 Init, UINT8 ubTargetNPC, UINT16 usActionCode, UINT8 ubQuoteNum);

extern BOOLEAN LetLuaMusicControl(UINT8 Init);

//----- Start Legion 2 -----
#ifdef LEGION2
extern BOOLEAN LetLuaPerformItemAction_Custom(UINT32 ActionID, INT32 sGridNo , UINT8 InitFunction);
extern BOOLEAN LetLuaGameInit_Custom(UINT8 Init);
extern BOOLEAN LetLuaGameInit_Text(UINT8 Init);
extern BOOLEAN LetLuaHourlyQuestUpdate_Custom(UINT8 Init);
extern BOOLEAN LetLuaHandleEarlyMorningEvents_Custom(UINT8 Init);
extern BOOLEAN LuaInitWorld(UINT8 Init);
extern BOOLEAN LuaPatche(UINT8 Init);
extern BOOLEAN LuaIDItemsScripts(UINT8 Init, UINT32 uiIndex);
extern BOOLEAN LuaSetSmallFaces ( UINT32 Init );
extern BOOLEAN LuaIDNPCRecordScripts(UINT8 Init, UINT32 uiNPC);
extern BOOLEAN LetLuaGameInitTest(UINT8 Init);
//custom files
extern BOOLEAN LuaInitWorld_Custom(UINT8 Init);
extern BOOLEAN LuaPatche_Custom(UINT8 Init);
extern BOOLEAN LuaSetSmallFaces_Custom ( UINT32 Init );
extern BOOLEAN LetLuaGameInit_Custom(UINT8 Init);
extern BOOLEAN LuaInternalQuest_Custom( UINT8 ubQuest, INT16 sSectorX, INT16 sSectorY, BOOLEAN fUpdateHistory, UINT16 usFact, UINT8 ubProfileID, UINT32 Init);
extern BOOLEAN LuaExecuteStrategicEvent_Custom( UINT8 EventCallbackID, UINT32 uiTimeStamp, UINT32 uiTimeOffset, UINT8	ubEventType, UINT8 ubFlags, UINT32 EventParam, UINT32 Init);
extern BOOLEAN LetLuaPerformItemAction_Custom(UINT32 ActionID, INT32 sGridNo , UINT8 InitFunction);
extern BOOLEAN LetLuaHourlyQuestUpdate_Custom(UINT8 Init);
extern BOOLEAN LetLuaHandleEarlyMorningEvents_Custom(UINT8 Init);
extern BOOLEAN LetHandleLoyaltyChangeForNPCAction_Custom(UINT8 ubNPCProfileId , UINT8 Init);
extern BOOLEAN LuaHandleGlobalLoyaltyEvent_Custom( UINT8 ubEventType, INT16 sSectorX, INT16 sSectorY, INT8 bSectorZ , UINT8 Init);
extern BOOLEAN LetLuaUpdateCustomMapMovementCosts(UINT8 Init);

#endif
//----- End Legion 2 -----

#endif
