#ifndef __HISTORY_H
#define __HISTORY_H

void GameInitHistory();
void EnterHistory();
void ExitHistory();
void HandleHistory();
void RenderHistory();


#define		HISTORY_DATA_FILE						"TEMP\\History.dat"

// the financial structure
struct history{
 UINT8 ubCode; // the code index in the finance code table
 UINT32 uiIdNumber; // unique id number
 UINT8 ubSecondCode; // secondary code 
 UINT32 uiDate; // time in the world in global time
 INT16 sSectorX; // sector X this took place in
 INT16 sSectorY; // sector Y this took place in
 INT8 bSectorZ;
 UINT8 ubColor;
 struct history *Next; // next unit in the list
};

typedef struct
{
	UINT32 uiIndex;
	CHAR16 sHistory[128];
	CHAR16 sHistory2[128];
	CHAR16 sKomunikat[400];
	CHAR16 sInneTeksty[400];
	
} HISTORY_VALUES;

extern HISTORY_VALUES HistoryName[500];

enum{
	HISTORY_ENTERED_HISTORY_MODE=0,
	HISTORY_HIRED_MERC_FROM_AIM,
	HISTORY_HIRED_MERC_FROM_MERC,
	HISTORY_MERC_KILLED,
	HISTORY_SETTLED_ACCOUNTS_AT_MERC,
	HISTORY_ACCEPTED_ASSIGNMENT_FROM_ENRICO,
	HISTORY_CHARACTER_GENERATED,
	HISTORY_PURCHASED_INSURANCE,
	HISTORY_CANCELLED_INSURANCE,
	HISTORY_INSURANCE_CLAIM_PAYOUT,
	HISTORY_EXTENDED_CONTRACT_1_DAY,
	HISTORY_EXTENDED_CONTRACT_1_WEEK,
	HISTORY_EXTENDED_CONTRACT_2_WEEK,
	HISTORY_MERC_FIRED,
	HISTORY_MERC_QUIT,
	HISTORY_QUEST_STARTED,
	HISTORY_QUEST_FINISHED,
	HISTORY_TALKED_TO_MINER,
	HISTORY_LIBERATED_TOWN,
	HISTORY_CHEAT_ENABLED,
	HISTORY_TALKED_TO_FATHER_WALKER,
	HISTORY_MERC_MARRIED_OFF,
	HISTORY_MERC_CONTRACT_EXPIRED,
	HISTORY_RPC_JOINED_TEAM,
	HISTORY_ENRICO_COMPLAINED,
	HISTORY_WONBATTLE,
	HISTORY_MINE_RUNNING_OUT,
	HISTORY_MINE_RAN_OUT,
	HISTORY_MINE_SHUTDOWN,
	HISTORY_MINE_REOPENED,
	HISTORY_DISCOVERED_TIXA,
	HISTORY_DISCOVERED_ORTA,
	HISTORY_GOT_ROCKET_RIFLES,
	HISTORY_DEIDRANNA_DEAD_BODIES,
	HISTORY_BOXING_MATCHES,
	HISTORY_SOMETHING_IN_MINES,
	HISTORY_DEVIN,
	HISTORY_MIKE,
	HISTORY_TONY,
	HISTORY_KROTT,
	HISTORY_KYLE,
	HISTORY_MADLAB,
	HISTORY_GABBY,
	HISTORY_KEITH_OUT_OF_BUSINESS,
	HISTORY_HOWARD_CYANIDE,
	HISTORY_KEITH,
	HISTORY_HOWARD,
	HISTORY_PERKO,
	HISTORY_SAM,
	HISTORY_FRANZ,
	HISTORY_ARNOLD,
	HISTORY_FREDO,
	HISTORY_RICHGUY_BALIME,
	HISTORY_JAKE,
	HISTORY_BUM_KEYCARD,
	HISTORY_WALTER,
	HISTORY_DAVE,
	HISTORY_PABLO,
	HISTORY_KINGPIN_MONEY,
	HISTORY_WON_BOXING,
	HISTORY_LOST_BOXING,
	HISTORY_DISQUALIFIED_BOXING,
	HISTORY_FOUND_MONEY,
	HISTORY_ASSASSIN,
	HISTORY_LOSTTOWNSECTOR,
	HISTORY_DEFENDEDTOWNSECTOR,
	HISTORY_LOSTBATTLE,
	HISTORY_FATALAMBUSH,
	HISTORY_WIPEDOUTENEMYAMBUSH,
	HISTORY_UNSUCCESSFULATTACK,
	HISTORY_SUCCESSFULATTACK,
	HISTORY_CREATURESATTACKED,
	HISTORY_KILLEDBYBLOODCATS,
	HISTORY_SLAUGHTEREDBLOODCATS,
	HISTORY_NPC_KILLED,
	HISTORY_GAVE_CARMEN_HEAD,
	HISTORY_SLAY_MYSTERIOUSLY_LEFT,
	HISTORY_MERC_KILLED_CHARACTER,
	//----- Start Legion 2 -----
	#ifdef LEGION2
	HISTORY_OFFICER_KILL, //78
	HISTORY_SKLEP_AKTYWNY,
	HISTORY_WARTOWNIA,
	HISTORY_WARTOWNIA_ZDOBYTA,
	HISTORY_LEGION2_4,
	HISTORY_LEGION2_5,
	HISTORY_LEGION2_6,	
	HISTORY_LEGION2_7,
	HISTORY_LEGION2_8,
	HISTORY_LEGION2_9,
	HISTORY_LEGION2_10,
	HISTORY_LEGION2_11,
    HISTORY_LEGION2_12,
	HISTORY_LEGION2_13,
	HISTORY_LEGION2_14,
	HISTORY_LEGION2_15,
	HISTORY_LEGION2_16,
	HISTORY_LEGION2_17,
	HISTORY_LEGION2_18,
	HISTORY_LEGION2_19,
	HISTORY_LEGION2_20,
	HISTORY_LEGION2_21,
	HISTORY_LEGION2_22,
	HISTORY_LEGION2_23,
	HISTORY_LEGION2_24,
	HISTORY_LEGION2_25,
	HISTORY_LEGION2_26,
	HISTORY_LEGION2_27,
	HISTORY_LEGION2_28,
	HISTORY_LEGION2_29,
	HISTORY_LEGION2_30,
	HISTORY_LEGION2_31,
	HISTORY_LEGION2_32,
	HISTORY_LEGION2_33,
	HISTORY_LEGION2_34,
	HISTORY_LEGION2_35,
	HISTORY_LEGION2_36,
	HISTORY_LEGION2_37,
	HISTORY_LEGION2_38,
	HISTORY_LEGION2_39,
	HISTORY_LEGION2_40,
	HISTORY_LEGION2_41,
	HISTORY_LEGION2_42,
	HISTORY_LEGION2_43,
	HISTORY_LEGION2_44,
	HISTORY_LEGION2_45,
	HISTORY_LEGION2_46,
	HISTORY_LEGION2_47,
	HISTORY_LEGION2_48,
	HISTORY_LEGION2_49,
	HISTORY_LEGION2_50,
	HISTORY_LEGION2_51,
	HISTORY_LEGION2_52,
	HISTORY_LEGION2_53,
	HISTORY_LEGION2_54,
	HISTORY_LEGION2_55,
	HISTORY_LEGION2_56,
	HISTORY_LEGION2_57,
	HISTORY_LEGION2_58,
	HISTORY_LEGION2_59,
	HISTORY_LEGION2_60,
	HISTORY_LEGION2_61,
	HISTORY_LEGION2_62,
	HISTORY_LEGION2_63,
	HISTORY_LEGION2_64,
	HISTORY_LEGION2_65,
	HISTORY_LEGION2_66,
	HISTORY_LEGION2_67,
	HISTORY_LEGION2_68,
	HISTORY_LEGION2_69,
	HISTORY_LEGION2_70,
	HISTORY_LEGION2_71,
	HISTORY_LEGION2_72,
	HISTORY_LEGION2_73,
	HISTORY_LEGION2_74,
	HISTORY_LEGION2_75,
	HISTORY_LEGION2_76,
	HISTORY_LEGION2_77,
	HISTORY_LEGION2_78,
	HISTORY_LEGION2_79,
	HISTORY_LEGION2_80,
	HISTORY_LEGION2_81,
	HISTORY_LEGION2_82,
	HISTORY_LEGION2_83,
	HISTORY_LEGION2_84,
	HISTORY_LEGION2_85,
	HISTORY_LEGION2_86,
	HISTORY_LEGION2_87,
	HISTORY_LEGION2_88,
	HISTORY_LEGION2_89,
	HISTORY_LEGION2_90,
	HISTORY_LEGION2_91,
	HISTORY_WALDO,
	HISTORY_HELICOPTER_REPAIR_STARTED,
	#else
	HISTORY_WALDO,
	HISTORY_HELICOPTER_REPAIR_STARTED,
	#endif
	//----- End Legion 2 -----
	TEXT_NUM_HISTORY
};

typedef struct history HistoryUnit;
typedef struct history *HistoryUnitPtr;

extern HistoryUnitPtr pHistoryListHead;

// reset history fact..for quests
void ResetHistoryFact( UINT8 ubCode, INT16 sSectorX, INT16 sSectorY );

// set history fact...to allow for a different color for in progress quests
UINT32 SetHistoryFact( UINT8 ubCode, UINT8 ubSecondCode, UINT32 uiDate, INT16 sSectorX, INT16 sSectorY );


UINT32 AddHistoryToPlayersLog(UINT8 ubCode, UINT8 ubSecondCode, UINT32 uiDate, INT16 sSectorX, INT16 sSectorY );
UINT32 GetTimeQuestWasStarted( UINT8 ubCode );

#endif



 


