/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class ItemPanel
extends InsetPanel
implements DataChangeListener {
    private Frame parent;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private ItemDetailPanel itemDetailPanel;
    private boolean modified = false;
    private Actor actor;
    private Mercenary merc;
    private Vector views = new Vector();
    private ItemView currentView;
    private DataChangeMixin mixin = new DataChangeMixin();
    static final long serialVersionUID = 12469L;

    public ItemPanel(Frame frame) {
        super(new Insets(10, 10, 10, 10));
        this.parent = frame;
        this.setLayout(this.layout);
        this.constraint.anchor = 16;
        this.constraint.fill = 0;
        this.constraint.gridx = 0;
        this.constraint.gridheight = 1;
        this.constraint.gridwidth = 1;
        this.constraint.weightx = 1.0;
        this.constraint.insets = new Insets(0, 0, 0, 0);
        this.newRow();
        this.addItem(3);
        this.addSpace();
        this.addItem(0);
        this.newRow();
        this.addItem(4);
        this.addSpace();
        this.addItem(1);
        this.newRow();
        this.addItem(5);
        this.addSpace();
        this.addItem(2);
        this.newRow();
        this.addItem(6);
        this.newRow();
        this.addItem(11);
        this.addItem(15);
        this.addItem(7);
        this.newRow();
        this.addItem(12);
        this.addItem(16);
        this.addItem(8);
        this.newRow();
        this.addItem(13);
        this.addItem(17);
        this.addItem(9);
        this.newRow();
        this.addItem(14);
        this.addItem(18);
        this.addItem(10);
        this.newRow();
        this.itemDetailPanel = new ItemDetailPanel(this.parent);
        this.constraint.gridwidth = 3;
        this.constraint.weightx = 1.0;
        this.constraint.weighty = 1.0;
        this.add((Component)this.itemDetailPanel, this.constraint);
        this.itemDetailPanel.addDataChangeListener(this);
    }

    private void addComponent(int n, Component component) {
        this.constraint.gridwidth = n;
        this.add(component, this.constraint);
        this.constraint.gridx += n;
    }

    public void addDataChangeListener(DataChangeListener dataChangeListener) {
        this.mixin.addDataChangeListener(dataChangeListener);
    }

    private void addItem(int n) {
        final ItemView itemView = new ItemView(n);
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                itemView.setBackground(new Color(0xA080A0));
                break;
            }
            case 3: 
            case 4: {
                itemView.setBackground(new Color(15777920));
                break;
            }
            case 5: 
            case 6: {
                itemView.setBackground(new Color(65392));
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                itemView.setBackground(new Color(0xE0E000));
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                itemView.setBackground(new Color(41120));
            }
        }
        this.addComponent(1, itemView);
        this.views.addElement(itemView);
        itemView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ItemPanel.this.doItemSelected(itemView);
            }
        });
    }

    private void addSpace() {
        ++this.constraint.gridx;
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        FieldView fieldView = (FieldView)dataChangeEvent.getSource();
        String string = dataChangeEvent.getOldValue();
        String string2 = dataChangeEvent.getNewValue();
        this.currentView.refresh();
        this.modified = true;
        this.fireDataChangeEvent(dataChangeEvent);
    }

    public void doItemSelected(ItemView itemView) {
        int n = itemView.getIndex();
        this.currentView = itemView;
        Item item = null;
        if (this.merc != null) {
            item = this.merc.items[n];
        }
        this.itemDetailPanel.setItem(item);
    }

    public void fireDataChangeEvent(DataChangeEvent dataChangeEvent) {
        this.mixin.fireDataChangeEvent(dataChangeEvent);
    }

    public boolean isModified() {
        return this.itemDetailPanel.isModified();
    }

    private void newRow() {
        ++this.constraint.gridy;
        this.constraint.gridx = 0;
    }

    public void removeDataChangeListener(DataChangeListener dataChangeListener) {
        this.mixin.removeDataChangeListener(dataChangeListener);
    }

    public void setActor(Actor actor, Mercenary mercenary) {
        this.actor = actor;
        this.merc = mercenary;
        for (int i = 0; i < this.views.size(); ++i) {
            ItemView itemView = (ItemView)this.views.elementAt(i);
            itemView.setActor(mercenary);
        }
        this.modified = false;
        this.doItemSelected((ItemView)this.views.elementAt(0));
    }

    public void setModified(boolean bl) {
        this.itemDetailPanel.setModified(bl);
        this.modified = bl;
    }
}

