/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Vector;

public class ItemDetailPanel
extends InsetPanel
implements DataChangeListener {
    private GridBagLayout layout = new GridBagLayout();
    private Frame parent;
    private GridBagConstraints constraint = new GridBagConstraints();
    private boolean modified = false;
    private Item item;
    private Vector views = new Vector();
    private Vector ammoComponents = new Vector();
    private Vector attachmentComponents = new Vector();
    private Vector moneyComponents = new Vector();
    private ChoiceView idView;
    private NumberView quantityView;
    private Label itemPctLabel;
    private NumberView[] itemPctViews = new NumberView[6];
    private Label ammoIdLabel;
    private ChoiceView ammoIdView;
    private Label ammoQuantityLabel;
    private NumberView ammoQuantityView;
    private Label ammoVarietyLabel;
    private NumberView ammoVarietyView;
    private Label ammoPctLabel;
    private NumberView ammoPctView;
    private ChoiceView[] attachmentIdViews = new ChoiceView[4];
    private NumberView[] attachmentPctViews = new NumberView[4];
    private Label moneyValueLabel;
    private NumberView moneyValueView;
    private DataChangeMixin mixin = new DataChangeMixin();
    private NumberView weightView;
    static final long serialVersionUID = 12469L;

    public ItemDetailPanel(Frame frame) {
        super(new Insets(10, 10, 10, 10));
        int n;
        this.parent = frame;
        this.setLayout(this.layout);
        this.constraint.anchor = 16;
        this.constraint.fill = 0;
        this.constraint.gridx = 0;
        this.constraint.gridheight = 1;
        this.constraint.gridwidth = 1;
        this.constraint.insets = new Insets(0, 0, 0, 0);
        this.newRow();
        this.addText(1, "Item");
        this.idView = this.addItemView(6, "Item ID", ItemExemplar.nameList);
        this.newRow();
        this.addText(1, "Anzahl der Items");
        this.quantityView = this.addByteView(1, "Quantity");
        this.newRow();
        this.itemPctLabel = this.addText(1, "Item %");
        for (n = 0; n < 6; ++n) {
            this.itemPctViews[n] = this.addByteView(1, "Item " + (n + 1) + " %");
        }
        this.newRow();
        this.ammoIdLabel = this.addText(1, "Munition");
        this.ammoComponents.addElement(this.ammoIdLabel);
        this.ammoIdView = this.addItemView(6, "Ammo ID", ItemExemplar.ammoNameList);
        this.ammoComponents.addElement(this.ammoIdView);
        this.newRow();
        this.ammoQuantityLabel = this.addText(1, "Kugelzahl");
        this.ammoComponents.addElement(this.ammoQuantityLabel);
        this.ammoQuantityView = this.addByteView(1, "Ammo Quantity");
        this.ammoComponents.addElement(this.ammoQuantityView);
        this.newRow();
        this.ammoVarietyLabel = this.addText(1, "Munition Variet\u00e4t");
        this.ammoComponents.addElement(this.ammoVarietyLabel);
        this.ammoVarietyView = this.addByteView(1, "Ammo Variety");
        this.ammoComponents.addElement(this.ammoVarietyView);
        this.newRow();
        this.ammoPctLabel = this.addText(1, "Munitionszustand %");
        this.ammoComponents.addElement(this.ammoPctLabel);
        this.ammoPctView = this.addByteView(1, "Ammo %");
        this.ammoComponents.addElement(this.ammoPctView);
        for (n = 0; n < 4; ++n) {
            NumberView numberView;
            ChoiceView choiceView;
            String string = "Erweiterung " + (n + 1);
            String string2 = "Attachment " + (n + 1);
            this.newRow();
            Label label = this.addText(1, string);
            this.attachmentComponents.addElement(label);
            this.attachmentIdViews[n] = choiceView = this.addItemView(6, string2 + " ID", ItemExemplar.attachmentNameList);
            this.attachmentComponents.addElement(choiceView);
            this.attachmentPctViews[n] = numberView = this.addByteView(1, string2 + " %");
            this.attachmentComponents.addElement(numberView);
            Label label2 = this.addText(1, "%");
            this.attachmentComponents.addElement(label2);
        }
        this.newRow();
        this.addText(1, "Gewicht (x 0.1 kg)");
        this.weightView = this.addByteView(1, "Weight");
        this.newRow();
        this.moneyValueLabel = this.addText(1, "Geldwert");
        this.moneyComponents.addElement(this.moneyValueLabel);
        this.moneyValueView = this.addShortView(2, "Money Value");
        this.moneyComponents.addElement(this.moneyValueView);
        this.newRow();
        this.constraint.fill = 1;
        this.constraint.weightx = 1.0;
        this.constraint.weighty = 1.0;
        this.addComponent(0, new Label());
    }

    public NumberView addByteView(int n, String string) {
        return this.addNumberView(1, string, 3);
    }

    private void addComponent(int n, Component component) {
        this.constraint.gridwidth = n;
        this.add(component, this.constraint);
        this.constraint.gridx += n;
    }

    public void addDataChangeListener(DataChangeListener dataChangeListener) {
        this.mixin.addDataChangeListener(dataChangeListener);
    }

    public ChoiceView addItemView(int n, String string, Vector vector) {
        ChoiceView choiceView = new ChoiceView(string, vector);
        this.constraint.fill = 2;
        this.addComponent(n, choiceView);
        this.views.addElement(choiceView);
        choiceView.addDataChangeListener(this);
        return choiceView;
    }

    private NumberView addNumberView(int n, String string, int n2) {
        NumberView numberView = new NumberView(string, n2);
        this.constraint.fill = 0;
        this.addComponent(n, numberView);
        this.views.addElement(numberView);
        numberView.addDataChangeListener(this);
        return numberView;
    }

    public NumberView addShortView(int n, String string) {
        return this.addNumberView(1, string, 3);
    }

    private Label addText(int n, String string) {
        return this.addText(n, string, 0);
    }

    private Label addText(int n, String string, int n2) {
        Label label = new Label(string, n2);
        this.constraint.fill = 2;
        this.addComponent(n, label);
        return label;
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        block18: {
            String string;
            String string2;
            FieldView fieldView;
            block19: {
                block17: {
                    fieldView = (FieldView)dataChangeEvent.getSource();
                    string2 = dataChangeEvent.getOldValue();
                    string = dataChangeEvent.getNewValue();
                    if (this.item == null) {
                        return;
                    }
                    if (fieldView != this.idView) break block17;
                    if (string2 == null || string2 == "") {
                        string2 = "Nichts";
                    }
                    if (string == null || string == "") {
                        string = "Nichts";
                    }
                    if (string2.equals("Nichts") && !string.equals("Nichts")) {
                        this.quantityView.setText("1");
                        this.itemPctViews[0].setEnabled(true);
                        this.itemPctViews[0].setText("100");
                    } else if (string.equals("Nichts")) {
                        this.quantityView.setText("0");
                        this.itemPctViews[0].setEnabled(true);
                        this.itemPctViews[0].setText("0");
                    }
                    ItemExemplar itemExemplar = this.item.getExemplar();
                    if (itemExemplar.category == 1) {
                        this.quantityView.setText("1");
                    } else if (itemExemplar.category == 4) {
                        int n = this.item.getInt("Quantity");
                        for (int i = 0; i < n; ++i) {
                            this.itemPctViews[i].setEnabled(true);
                            this.itemPctViews[i].setText(String.valueOf(itemExemplar.ammoCapacity));
                        }
                    }
                    this.setEnabledAll();
                    break block18;
                }
                if (fieldView != this.ammoIdView) break block19;
                if (string2 == null || string2 == "") {
                    string2 = "Nichts";
                }
                if (string == null || string == "") {
                    string = "Nichts";
                }
                if (string.equals("Nichts") || string.equals(string2)) break block18;
                int n = this.item.getInt("Ammo ID");
                ItemExemplar itemExemplar = (ItemExemplar)ItemExemplar.exemplarTable.get(new Integer(n));
                System.err.println(String.valueOf(itemExemplar.ammoVariety));
                this.ammoVarietyView.setText(String.valueOf(itemExemplar.ammoVariety));
                this.ammoQuantityView.setText(String.valueOf(itemExemplar.ammoCapacity));
                this.ammoPctView.setText("100");
                break block18;
            }
            if (fieldView == this.quantityView) {
                this.setEnabledAll();
            } else {
                for (int i = 0; i < this.attachmentIdViews.length; ++i) {
                    if (fieldView != this.attachmentIdViews[i]) continue;
                    if (string2 == null || string2 == "") {
                        string2 = "Nichts";
                    }
                    if (string == null || string == "") {
                        string = "Nichts";
                    }
                    if (!string2.equals("Nichts") || string.equals("Nichts")) break;
                    this.attachmentPctViews[i].setText("100");
                    break;
                }
            }
        }
        this.modified = true;
        this.fireDataChangeEvent(dataChangeEvent);
    }

    public void fireDataChangeEvent(DataChangeEvent dataChangeEvent) {
        this.mixin.fireDataChangeEvent(dataChangeEvent);
    }

    public boolean isModified() {
        return this.modified;
    }

    private void newRow() {
        ++this.constraint.gridy;
        this.constraint.gridx = 0;
    }

    public void removeDataChangeListener(DataChangeListener dataChangeListener) {
        this.mixin.removeDataChangeListener(dataChangeListener);
    }

    public void setEnabled(Vector vector, boolean bl) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            component.setEnabled(bl);
        }
    }

    public void setEnabledAll() {
        if (this.item == null) {
            return;
        }
        ItemExemplar itemExemplar = this.item.getExemplar();
        switch (itemExemplar.category) {
            case 1: {
                this.setEnabled(this.ammoComponents, true);
                this.setEnabled(this.attachmentComponents, true);
                this.setEnabled(this.moneyComponents, false);
                break;
            }
            case 9: {
                this.setEnabled(this.ammoComponents, false);
                this.setEnabled(this.attachmentComponents, true);
                this.setEnabled(this.moneyComponents, false);
                break;
            }
            case 18: {
                this.setEnabled(this.ammoComponents, false);
                this.setEnabled(this.attachmentComponents, false);
                this.setEnabled(this.moneyComponents, true);
                break;
            }
            default: {
                this.setEnabled(this.ammoComponents, false);
                this.setEnabled(this.attachmentComponents, false);
                this.setEnabled(this.moneyComponents, false);
            }
        }
        int n = this.item.getInt("Quantity");
        for (int i = 0; i < 6; ++i) {
            this.itemPctViews[i].setEnabled(i < n);
        }
        if (n == 0) {
            this.itemPctLabel.setEnabled(false);
        } else {
            this.itemPctLabel.setEnabled(true);
        }
        if (itemExemplar.category == 4) {
            this.itemPctLabel.setText("Number of Rounds");
        } else {
            this.itemPctLabel.setText("Item %");
        }
    }

    public void setItem(Item item) {
        this.item = item;
        Enumeration enumeration = this.views.elements();
        while (enumeration.hasMoreElements()) {
            FieldView fieldView = (FieldView)enumeration.nextElement();
            fieldView.setStruct(item);
            fieldView.refresh();
        }
        this.setEnabledAll();
        this.modified = false;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }
}

