/*
 * Decompiled with CFR 0.152.
 */
package duggelz.jape;

import duggelz.jape.Actor;
import duggelz.jape.ByteField;
import duggelz.jape.JapeAlg;
import duggelz.jape.JapeConst;
import duggelz.jape.Mercenary;
import duggelz.jape.ShortField;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class SaveGame {
    public static final int SAVED_GAME_HEADER_Offset = 0;
    public static final int SAVED_GAME_HEADER_Length_99 = 432;
    public static final int SAVED_GAME_HEADER_Length_103 = 436;
    public static final int uiSavedGameVersion_Offset = 0;
    public static final int uiSavedGameVersion_Length = 4;
    public static final int uiDay_Offset = 280;
    public static final int ubHour_Offset = 284;
    public static final int ubMin_Offset = 285;
    public static final int iCurrentBalance_Offset = 292;
    public static final int sInitialGameOptions_Offset = 303;
    public static final int sInitialGameOptions_Length_99 = 12;
    public static final int sInitialGameOptions_Length_103 = 14;
    public static final int uiRandom_Offset = 320;
    public static final int ubInventorySystem_Offset_103 = 324;
    public static final int TacticalStatusType_Offset_99 = 432;
    public static final int TacticalStatusType_Offset_103 = 436;
    public static final int TacticalStatusType_Length = 316;
    public static final int gWorldSectorXYZ_Offset_99 = 748;
    public static final int gWorldSectorXYZ_Offset_103 = 752;
    public static final int gWorldSectorXYZ_Length = 5;
    public static final int GameClock_Offset_99 = 753;
    public static final int GameClock_Offset_103 = 757;
    public static final int GameClock_Length = 62;
    public static final int uiNumGameEvents_Offset_99 = 815;
    public static final int uiNumGameEvents_Offset_103 = 819;
    public static final int STRATEGICEVENT_Offset_99 = 819;
    public static final int STRATEGICEVENT_Offset_103 = 823;
    public static final int STRATEGICEVENT_Length = 28;
    public static final int MAXITEMS_99 = 351;
    public static final int MAXITEMS_103 = 5001;
    public static final int LaptopSaveInfoStruct_Length_99 = 7440;
    public static final int LaptopSaveInfoStruct_Length_103 = 81840;
    public static final int BobbyRayInventory_RelOffset = 1654;
    public static final int usNumberOfBobbyRayOrderItems_RelOffset_99 = 7276;
    public static final int usNumberOfBobbyRayOrderItems_RelOffset_103 = 81676;
    public static final int BobbyRayOrderStruct_Length = 84;
    public static final int ubNumberLifeInsurancePayouts_RelOffset_99 = 7284;
    public static final int ubNumberLifeInsurancePayouts_RelOffset_103 = 81684;
    public static final int MERCPROFILESTRUCT_Count = 170;
    public static final int MERCPROFILESTRUCT_Length_99 = 716;
    public static final int MERCPROFILESTRUCT_Length_103 = 632;
    public static final int MERCPROFILESTRUCT_invsize_RelOffset_103 = 632;
    public static final int TOTAL_SOLDIERS = 156;
    public static final int SOLDIERTYPE_Length_99 = 2328;
    public static final int SOLDIERTYPE_Length_103 = 1072;
    public static final int SOLDIERTYPE_TrailingLength_103 = 525;
    public static final int PathSt_Length = 20;
    public static final int NUM_KEYS = 64;
    public static final int KEY_ON_RING_Length = 2;
    public static final int OBJECTTYPE_Length_103 = 5;
    public static final int STACKEDOBJECTDATA_Length_103 = 16;
    public static final int LBENODE_Length_103 = 16;
    public String filename;
    public RandomAccessFile file;
    public int codeTableIdx;
    public int codeTableSubIdx;
    public int[] codeTable;
    public int uiSavedGameVersion = 0;
    public int STRATEGICEVENT_Count = 0;
    public int LaptopSaveInfoStruct_Offset = 0;
    public int usNumberOfBobbyRayOrderItems = 0;
    public int ubNumberLifeInsurancePayouts = 0;
    public int actorCount = 170;
    public int actorOffset = 0;
    public Actor[] actors = new Actor[170];
    public int mercCount = 0;
    public int mercOffset = 0;
    public Mercenary[] mercs = new Mercenary[156];
    public int SAVED_GAME_HEADER_Length;
    public int sInitialGameOptionsLength;
    public int TacticalStatusType_Offset;
    public int gWorldSectorXYZ_Offset;
    public int GameClock_Offset;
    public int uiNumGameEvents_Offset;
    public int STRATEGICEVENT_Offset;
    public int MAXITEMS;
    public int LaptopSaveInfoStruct_Length;
    public int usNumberOfBobbyRayOrderItems_RelOffset;
    public int ubNumberLifeInsurancePayouts_RelOffset;
    public int MERCPROFILESTRUCT_Length;
    public int SOLDIERTYPE_Length;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String filename) throws IOException, FormatException {
        this.filename = filename;
        this.file = new RandomAccessFile(this.filename, "r");
        try {
            this.file.seek(0L);
            this.uiSavedGameVersion = this.readIntLE(this.file);
            System.out.println("Read saved game " + this.filename + ", version=" + this.uiSavedGameVersion);
            if (this.uiSavedGameVersion >= 95 && this.uiSavedGameVersion <= 99) {
                this.SAVED_GAME_HEADER_Length = 432;
                this.sInitialGameOptionsLength = 12;
                this.TacticalStatusType_Offset = 432;
                this.gWorldSectorXYZ_Offset = 748;
                this.GameClock_Offset = 753;
                this.uiNumGameEvents_Offset = 815;
                this.STRATEGICEVENT_Offset = 819;
                this.MAXITEMS = 351;
                this.LaptopSaveInfoStruct_Length = 7440;
                this.usNumberOfBobbyRayOrderItems_RelOffset = 7276;
                this.ubNumberLifeInsurancePayouts_RelOffset = 7284;
                this.MERCPROFILESTRUCT_Length = 716;
                this.SOLDIERTYPE_Length = 2328;
            } else if (this.uiSavedGameVersion >= 103 && this.uiSavedGameVersion <= 103) {
                this.SAVED_GAME_HEADER_Length = 436;
                this.sInitialGameOptionsLength = 14;
                this.TacticalStatusType_Offset = 436;
                this.gWorldSectorXYZ_Offset = 752;
                this.GameClock_Offset = 757;
                this.uiNumGameEvents_Offset = 819;
                this.STRATEGICEVENT_Offset = 823;
                this.MAXITEMS = 5001;
                this.LaptopSaveInfoStruct_Length = 81840;
                this.usNumberOfBobbyRayOrderItems_RelOffset = 81676;
                this.ubNumberLifeInsurancePayouts_RelOffset = 81684;
                this.MERCPROFILESTRUCT_Length = 632;
                this.SOLDIERTYPE_Length = 1072;
            } else {
                throw new FormatException("Save game version " + this.uiSavedGameVersion + " not supported.  " + "Supported values are 95, 96, 97, 97, 99 and 103");
            }
            this.file.seek(this.uiNumGameEvents_Offset);
            this.STRATEGICEVENT_Count = this.readIntLE(this.file);
            if (this.STRATEGICEVENT_Count < 0 || this.STRATEGICEVENT_Count > 1000) {
                throw new FormatException("Internal Error: STRATEGICEVENT_Count = " + this.STRATEGICEVENT_Count);
            }
            this.actorOffset = this.STRATEGICEVENT_Offset + this.STRATEGICEVENT_Count * 28 + this.LaptopSaveInfoStruct_Length;
            this.file.seek(this.actorOffset);
            byte[] rawData = new byte[16];
            this.file.readFully(rawData);
            int[] indexes = this.findActorCodeTable(rawData);
            if (indexes == null) {
                throw new FormatException("Unable to determine code table");
            }
            this.codeTableIdx = indexes[0];
            this.codeTableSubIdx = indexes[1];
            this.codeTable = (int[])(indexes[0] == -1 ? null : JapeConst.CodeTables[this.codeTableIdx][this.codeTableSubIdx]);
            this.loadActors();
            this.mercOffset = (int)this.file.getFilePointer();
            this.loadMercs();
        }
        finally {
            this.file.close();
        }
    }

    public void loadActors() throws IOException, FormatException {
        this.file.seek(this.actorOffset);
        int idx = 0;
        while (true) {
            if (idx >= 170) break;
            ByteArrayOutputStream actorData = new ByteArrayOutputStream();
            byte[] mercProfileStructData = new byte[this.MERCPROFILESTRUCT_Length];
            this.file.readFully(mercProfileStructData);
            actorData.write(mercProfileStructData, 0, mercProfileStructData.length);
            if (this.uiSavedGameVersion == 103) {
                int inventorySize = this.readIntLE(this.file);
                this.writeIntLE(actorData, inventorySize);
                if (inventorySize < 0 || inventorySize > 1000) {
                    throw new FormatException("Invalid inventory size " + inventorySize + " for MERCPROFILESTRUCT " + idx);
                }
                for (int itemIdx = 0; itemIdx < inventorySize; ++itemIdx) {
                    byte[] inventoryItem = new byte[12];
                    this.file.readFully(inventoryItem);
                    actorData.write(inventoryItem, 0, inventoryItem.length);
                }
            }
            Actor actor = new Actor(actorData.toByteArray(), this.uiSavedGameVersion, this.codeTable);
            actor.validateChecksum();
            System.out.println("Read MERCPROFILE '" + actor.get("Nickname") + "'");
            this.actors[idx] = actor;
            ++idx;
        }
    }

    public void loadMercs() throws IOException, FormatException {
        this.file.seek(this.mercOffset);
        int mercIdx = 0;
        while (true) {
            if (mercIdx >= 156) break;
            byte initialActive = this.file.readByte();
            if (initialActive != 0) {
                this.file.seek(this.file.getFilePointer() - 1L);
                break;
            }
            ++mercIdx;
            ++this.mercOffset;
        }
        while (true) {
            if (mercIdx >= 156) break;
            int trailingOffset = 0;
            ByteArrayOutputStream mercData = new ByteArrayOutputStream();
            byte ubActive = this.file.readByte();
            mercData.write(ubActive);
            if (ubActive != 1) {
                throw new FormatException("ubActive = " + ubActive);
            }
            byte[] soldierData = new byte[this.SOLDIERTYPE_Length];
            this.file.readFully(soldierData);
            mercData.write(soldierData, 0, soldierData.length);
            int inventorySum = 0;
            if (this.uiSavedGameVersion == 103) {
                inventorySum = this.inventoryLoad_103(this.file, mercData);
                trailingOffset = mercData.size() - 1;
                byte[] trailingData = new byte[525];
                this.file.readFully(trailingData);
                mercData.write(trailingData, 0, trailingData.length);
            }
            int uiNumOfNodes = this.readIntLE(this.file);
            this.writeIntLE(mercData, uiNumOfNodes);
            if (uiNumOfNodes < 0 || uiNumOfNodes > 1000) {
                throw new FormatException("Internal error: uiNumOfNodes=" + uiNumOfNodes);
            }
            byte[] pathStData = new byte[uiNumOfNodes * 20];
            this.file.readFully(pathStData);
            mercData.write(pathStData, 0, pathStData.length);
            byte ubOne = this.file.readByte();
            mercData.write(ubOne);
            if (ubOne != 1 && ubOne != 0) {
                throw new FormatException("ubOne = " + ubOne);
            }
            if (ubOne == 1) {
                byte[] keyRingData = new byte[64 * 2];
                this.file.readFully(keyRingData);
                mercData.write(keyRingData, 0, keyRingData.length);
            }
            while (true) {
                if (mercIdx >= 156) break;
                byte nextActive = this.file.readByte();
                if (nextActive != 0) {
                    this.file.seek(this.file.getFilePointer() - 1L);
                    break;
                }
                ++mercIdx;
                mercData.write(nextActive);
            }
            Mercenary merc = new Mercenary(mercData.toByteArray(), this.uiSavedGameVersion, trailingOffset, inventorySum, this.codeTable);
            System.out.println("Read SOLDIERTYPE '" + merc.get("Nickname") + "'");
            merc.validateChecksum();
            this.mercs[this.mercCount] = merc;
            ++this.mercCount;
            ++mercIdx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        this.file = new RandomAccessFile(this.filename, "rw");
        try {
            this.saveActors();
            this.saveMercs();
        }
        finally {
            this.file.close();
        }
    }

    public void saveActors() throws IOException {
        this.file.seek(this.actorOffset);
        int idx = 0;
        while (true) {
            if (idx >= 170) break;
            Actor actor = this.actors[idx];
            byte[] actorData = actor.encode(this.codeTable);
            this.file.write(actorData);
            ++idx;
        }
    }

    public void saveMercs() throws IOException {
        this.file.seek(this.mercOffset);
        for (int idx = 0; idx < this.mercCount; ++idx) {
            Mercenary merc = this.mercs[idx];
            byte[] mercData = merc.encode(this.codeTable);
            this.file.write(mercData);
        }
    }

    public int[] findActorCodeTable(byte[] ciphertext) {
        for (int mainTable = 0; mainTable < 4; ++mainTable) {
            for (int subTable = 0; subTable < 57; ++subTable) {
                byte[] plaintext = JapeAlg.Decode(ciphertext, 8, JapeConst.CodeTables[mainTable][subTable]);
                if (plaintext[1] != 0 || plaintext[3] != 0 || plaintext[5] != 0 || plaintext[7] != 0) continue;
                int[] results = new int[]{mainTable, subTable};
                return results;
            }
        }
        if (ciphertext[1] == 0 && ciphertext[3] == 0 && ciphertext[5] == 0 && ciphertext[7] == 0) {
            int[] results = new int[]{-1, -1};
            return results;
        }
        return null;
    }

    public Actor getActor(int idx) {
        return this.actors[idx];
    }

    public Mercenary getMerc(int idx) {
        return this.mercs[idx];
    }

    public Actor getActorByNick(String nick) {
        int idx = 0;
        while (true) {
            if (idx >= 170) break;
            Actor actor = this.actors[idx];
            if (actor != null && actor.get("Nickname").equals(nick)) {
                return actor;
            }
            ++idx;
        }
        return null;
    }

    public Mercenary getMercByNick(String nick) {
        for (int idx = 0; idx < this.mercCount; ++idx) {
            Mercenary merc = this.mercs[idx];
            if (merc == null || !merc.get("Nickname").equals(nick)) continue;
            return merc;
        }
        return null;
    }

    public int readIntLE(DataInput d) throws IOException {
        int i = d.readInt();
        int j = (i & 0xFF) << 24 | (i & 0xFF00) << 8 | (i & 0xFF0000) >>> 8 | (i & 0xFF000000) >>> 24;
        return j;
    }

    public void writeIntLE(OutputStream os, int i) throws IOException {
        os.write(i & 0xFF);
        os.write((i & 0xFF00) >>> 8);
        os.write((i & 0xFF0000) >>> 16);
        os.write((i & 0xFF000000) >>> 24);
    }

    public int inventoryLoad_103(DataInput file, OutputStream mercData) throws IOException, FormatException {
        int inventorySize = this.readIntLE(file);
        this.writeIntLE(mercData, inventorySize);
        if (inventorySize < 0 || inventorySize > 55) {
            throw new FormatException("Invalid inventory size " + inventorySize);
        }
        int sum = 0;
        for (int itemIdx = 0; itemIdx < inventorySize; ++itemIdx) {
            sum += this.objecttypeLoad_103(file, mercData);
            int bNewItemCount = this.readIntLE(file);
            this.writeIntLE(mercData, bNewItemCount);
            int bNewItemCycleCount = this.readIntLE(file);
            this.writeIntLE(mercData, bNewItemCycleCount);
        }
        return sum;
    }

    public int objecttypeLoad_103(DataInput file, OutputStream mercData) throws IOException, FormatException {
        byte[] obj = new byte[5];
        file.readFully(obj);
        mercData.write(obj);
        ShortField usItem = new ShortField(0);
        ByteField ubNumberOfObjects = new ByteField(2);
        int sum = usItem.getInt(obj) + ubNumberOfObjects.getInt(obj);
        int objStackSize = this.readIntLE(file);
        this.writeIntLE(mercData, objStackSize);
        if (objStackSize < 0 || objStackSize > 55) {
            throw new FormatException("Invalid object stack size " + objStackSize);
        }
        for (int idx = 0; idx < objStackSize; ++idx) {
            this.stackedObjectDataLoad_103(file, mercData);
        }
        return sum;
    }

    public void stackedObjectDataLoad_103(DataInput file, OutputStream mercData) throws IOException, FormatException {
        byte[] sob = new byte[16];
        file.readFully(sob);
        mercData.write(sob);
        int attachmentsSize = this.readIntLE(file);
        this.writeIntLE(mercData, attachmentsSize);
        if (attachmentsSize < 0 || attachmentsSize > 55) {
            throw new FormatException("Invalid attachment size " + attachmentsSize);
        }
        for (int idx = 0; idx < attachmentsSize; ++idx) {
            this.objecttypeLoad_103(file, mercData);
        }
    }

    public static void main(String[] args) {
        File saveDir = new File("Saves");
        File[] filenames = saveDir.listFiles();
        for (int idx = 0; idx < filenames.length; ++idx) {
            File filename = filenames[idx];
            if (!filename.getName().endsWith(".sav")) continue;
            SaveGame saveGame = new SaveGame();
            try {
                saveGame.load(filename.getPath());
                continue;
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                continue;
            }
            catch (FormatException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static class FormatException
    extends Exception {
        public FormatException(String message) {
            super(message);
        }
    }
}

