/*
 * Decompiled with CFR 0.152.
 */
package duggelz.jape;

import duggelz.jape.BasicStructure;
import duggelz.jape.ByteField;
import duggelz.jape.ChoiceField;
import duggelz.jape.IntField;
import duggelz.jape.Item;
import duggelz.jape.JapeAlg;
import duggelz.jape.SaveGame;
import duggelz.jape.Skill;
import duggelz.jape.StringField;
import java.util.Hashtable;

public class Mercenary
extends BasicStructure {
    public static final int CIPHERTEXT_OFFSET = 1;
    public static final int CIPHERTEXT_LENGTH = 2328;
    public static final int FIRST_ITEM_OFFSET = 12;
    public static final int ITEM_LENGTH = 36;
    public static final int ITEM_COUNT = 19;
    public static final int HELMET_INDEX = 0;
    public static final int BODY_ARMOR_INDEX = 1;
    public static final int LEG_ARMOR_INDEX = 2;
    public static final int HEADGEAR_1_INDEX = 3;
    public static final int HEADGEAR_2_INDEX = 4;
    public static final int RIGHT_HAND_INDEX = 5;
    public static final int LEFT_HAND_INDEX = 6;
    public static final int BACKPACK_1_3_INDEX = 7;
    public static final int BACKPACK_2_3_INDEX = 8;
    public static final int BACKPACK_3_3_INDEX = 9;
    public static final int BACKPACK_4_3_INDEX = 10;
    public static final int BACKPACK_1_1_INDEX = 11;
    public static final int BACKPACK_2_1_INDEX = 12;
    public static final int BACKPACK_3_1_INDEX = 13;
    public static final int BACKPACK_4_1_INDEX = 14;
    public static final int BACKPACK_1_2_INDEX = 15;
    public static final int BACKPACK_2_2_INDEX = 16;
    public static final int BACKPACK_3_2_INDEX = 17;
    public static final int BACKPACK_4_2_INDEX = 18;
    public static final int ENERGY_OFFSET_99 = 711;
    public static final int ENERGY_OFFSET_103 = 45;
    public static final int MAX_ENERGY_OFFSET_99 = 712;
    public static final int MAX_ENERGY_OFFSET_103 = 46;
    public static final int NICK_OFFSET_99 = 730;
    public static final int NICK_OFFSET_103 = 2;
    public static final int NICK_LENGTH = 20;
    public static final int ubProfile_Offset_103 = 717;
    public static final int CHECKSUM_OFFSET_99 = 2208;
    public static final int CHECKSUM_OFFSET_103 = 972;
    public static final int CHECKSUM_LENGTH = 4;
    public static final int MORALE_OFFSET_99 = 1736;
    public static final int MORALE_OFFSET_103 = 204;
    public static final int statsOffset_103 = 428;
    public static final int SKILL1_OFFSET_99 = 832;
    public static final int SKILL1_OFFSET_103 = 436;
    public static final int SKILL2_OFFSET_99 = 833;
    public static final int SKILL2_OFFSET_103 = 437;
    public static final int DEX_OFFSET_99 = 840;
    public static final int DEX_OFFSET_103 = 438;
    public static final int WIS_OFFSET_99 = 841;
    public static final int WIS_OFFSET_103 = 439;
    public static final int LVL_OFFSET_99 = 849;
    public static final int LVL_OFFSET_103 = 430;
    public static final int HEALTH_OFFSET_99 = 868;
    public static final int HEALTH_OFFSET_103 = 428;
    public static final int AGI_OFFSET_99 = 880;
    public static final int AGI_OFFSET_103 = 431;
    public static final int STR_OFFSET_99 = 886;
    public static final int STR_OFFSET_103 = 432;
    public static final int LDR_OFFSET_99 = 895;
    public static final int LDR_OFFSET_103 = 442;
    public static final int MEC_OFFSET_99 = 916;
    public static final int MEC_OFFSET_103 = 433;
    public static final int MAX_HEALTH_OFFSET_99 = 917;
    public static final int MAX_HEALTH_OFFSET_103 = 429;
    public static final int MED_OFFSET_99 = 1372;
    public static final int MED_OFFSET_103 = 440;
    public static final int MRK_OFFSET_99 = 1377;
    public static final int MRK_OFFSET_103 = 434;
    public static final int EXP_OFFSET_99 = 1378;
    public static final int EXP_OFFSET_103 = 435;
    public byte[] allData;
    public Item[] items = new Item[19];
    public int savedGameVersion;
    public int trailingOffset;
    public int inventorySum;
    public int ENERGY_OFFSET;
    public int MAX_ENERGY_OFFSET;
    public int NICK_OFFSET;
    public int CHECKSUM_OFFSET;
    public int MORALE_OFFSET;
    public int SKILL1_OFFSET;
    public int SKILL2_OFFSET;
    public int DEX_OFFSET;
    public int WIS_OFFSET;
    public int LVL_OFFSET;
    public int HEALTH_OFFSET;
    public int AGI_OFFSET;
    public int STR_OFFSET;
    public int LDR_OFFSET;
    public int MEC_OFFSET;
    public int MAX_HEALTH_OFFSET;
    public int MED_OFFSET;
    public int MRK_OFFSET;
    public int EXP_OFFSET;

    public Mercenary(byte[] rawData, int savedGameVersion, int trailingOffset, int inventorySum, int[] table) {
        super(new Hashtable());
        this.savedGameVersion = savedGameVersion;
        this.trailingOffset = trailingOffset;
        this.inventorySum = inventorySum;
        this.decode(rawData, table);
        if (savedGameVersion <= 99) {
            this.ENERGY_OFFSET = 711;
            this.MAX_ENERGY_OFFSET = 712;
            this.NICK_OFFSET = 730;
            this.CHECKSUM_OFFSET = 2208;
            this.MORALE_OFFSET = 1736;
            this.SKILL1_OFFSET = 832;
            this.SKILL2_OFFSET = 833;
            this.DEX_OFFSET = 840;
            this.WIS_OFFSET = 841;
            this.LVL_OFFSET = 849;
            this.HEALTH_OFFSET = 868;
            this.AGI_OFFSET = 880;
            this.STR_OFFSET = 886;
            this.LDR_OFFSET = 895;
            this.MEC_OFFSET = 916;
            this.MAX_HEALTH_OFFSET = 917;
            this.MED_OFFSET = 1372;
            this.MRK_OFFSET = 1377;
            this.EXP_OFFSET = 1378;
        } else {
            this.ENERGY_OFFSET = 45;
            this.MAX_ENERGY_OFFSET = 46;
            this.NICK_OFFSET = 2;
            this.CHECKSUM_OFFSET = 972;
            this.MORALE_OFFSET = trailingOffset + 204;
            this.SKILL1_OFFSET = trailingOffset + 436;
            this.SKILL2_OFFSET = trailingOffset + 437;
            this.DEX_OFFSET = trailingOffset + 438;
            this.WIS_OFFSET = trailingOffset + 439;
            this.LVL_OFFSET = trailingOffset + 430;
            this.HEALTH_OFFSET = trailingOffset + 428;
            this.AGI_OFFSET = trailingOffset + 431;
            this.STR_OFFSET = trailingOffset + 432;
            this.LDR_OFFSET = trailingOffset + 442;
            this.MEC_OFFSET = trailingOffset + 433;
            this.MAX_HEALTH_OFFSET = trailingOffset + 429;
            this.MED_OFFSET = trailingOffset + 440;
            this.MRK_OFFSET = trailingOffset + 434;
            this.EXP_OFFSET = trailingOffset + 435;
        }
        this.fields.put("Energy", new ByteField(this.ENERGY_OFFSET));
        this.fields.put("Max Energy", new ByteField(this.MAX_ENERGY_OFFSET));
        this.fields.put("Nickname", new StringField(this.NICK_OFFSET, 20));
        this.fields.put("Skill1", new ChoiceField(new ByteField(this.SKILL1_OFFSET), Skill.table));
        this.fields.put("Skill2", new ChoiceField(new ByteField(this.SKILL2_OFFSET), Skill.table));
        this.fields.put("Dexterity", new ByteField(this.DEX_OFFSET));
        this.fields.put("Wisdom", new ByteField(this.WIS_OFFSET));
        this.fields.put("Level", new ByteField(this.LVL_OFFSET));
        this.fields.put("Health", new ByteField(this.HEALTH_OFFSET));
        this.fields.put("Agility", new ByteField(this.AGI_OFFSET));
        this.fields.put("Strength", new ByteField(this.STR_OFFSET));
        this.fields.put("Leadership", new ByteField(this.LDR_OFFSET));
        this.fields.put("Mechanical", new ByteField(this.MEC_OFFSET));
        this.fields.put("Max Health", new ByteField(this.MAX_HEALTH_OFFSET));
        this.fields.put("Medical", new ByteField(this.MED_OFFSET));
        this.fields.put("Marksmanship", new ByteField(this.MRK_OFFSET));
        this.fields.put("Explosives", new ByteField(this.EXP_OFFSET));
        this.fields.put("Morale", new ByteField(this.MORALE_OFFSET));
        this.fields.put("ubProfile", new ByteField(717));
        this.fields.put("Checksum", new IntField(this.CHECKSUM_OFFSET));
    }

    public void decode(byte[] rawData, int[] table) {
        this.allData = new byte[rawData.length];
        System.arraycopy(rawData, 0, this.allData, 0, this.allData.length);
        if (this.savedGameVersion <= 99) {
            byte[] ciphertext = new byte[2328];
            System.arraycopy(rawData, 1, ciphertext, 0, 2328);
            byte[] plaintext = JapeAlg.Decode(ciphertext, ciphertext.length, table);
            this.data = plaintext;
            int idx = 0;
            while (true) {
                if (idx < 19) {
                    Item item;
                    byte[] itemData = new byte[36];
                    int itemOffset = 12 + idx * 36;
                    System.arraycopy(this.data, itemOffset, itemData, 0, 36);
                    this.items[idx] = item = new Item(itemData);
                    ++idx;
                    continue;
                }
                break;
            }
        } else {
            this.data = new byte[rawData.length - 1];
            System.arraycopy(rawData, 1, this.data, 0, this.data.length);
        }
    }

    public byte[] encode(int[] table) {
        if (this.savedGameVersion <= 99) {
            int idx = 0;
            while (true) {
                if (idx >= 19) break;
                Item item = this.items[idx];
                byte[] itemData = item.encode();
                int itemOffset = 12 + idx * 36;
                System.arraycopy(itemData, 0, this.data, itemOffset, 36);
                ++idx;
            }
        }
        this.recomputeChecksum();
        byte[] rawData = new byte[this.allData.length];
        System.arraycopy(this.allData, 0, rawData, 0, this.allData.length);
        if (this.savedGameVersion <= 99) {
            byte[] plaintext = new byte[2328];
            System.arraycopy(this.data, 0, plaintext, 0, 2328);
            byte[] ciphertext = JapeAlg.Encode(plaintext, plaintext.length, table);
            System.arraycopy(ciphertext, 0, rawData, 1, 2328);
        } else {
            System.arraycopy(this.data, 0, rawData, 1, this.data.length);
        }
        return rawData;
    }

    public int computeChecksum() {
        if (this.savedGameVersion <= 99) {
            return JapeAlg.MercChecksum(this.data);
        }
        int checksum = 1;
        checksum += this.getInt("Health") + 1;
        checksum *= this.getInt("Max Health") + 1;
        checksum += this.getInt("Agility") + 1;
        checksum *= this.getInt("Dexterity") + 1;
        checksum += this.getInt("Strength") + 1;
        checksum *= this.getInt("Marksmanship") + 1;
        checksum += this.getInt("Medical") + 1;
        checksum *= this.getInt("Mechanical") + 1;
        checksum += this.getInt("Explosives") + 1;
        checksum *= this.getInt("Level") + 1;
        checksum += this.getInt("ubProfile") + 1;
        return checksum += this.inventorySum;
    }

    public void validateChecksum() throws SaveGame.FormatException {
        int savedChecksum;
        int checksum = this.computeChecksum();
        if (checksum != (savedChecksum = this.getInt("Checksum"))) {
            throw new SaveGame.FormatException("Invalid checksum (0x" + Integer.toHexString(checksum) + " vs 0x" + Integer.toHexString(savedChecksum) + ") in SOLDIERTYPE for '" + this.get("Nickname") + "'");
        }
    }

    public void recomputeChecksum() {
        int checksum = this.computeChecksum();
        this.setInt("Checksum", checksum);
    }
}

