/*
 * Decompiled with CFR 0.152.
 */
package duggelz.jape;

import duggelz.jape.DataChangeEvent;
import duggelz.jape.DataChangeListener;
import duggelz.jape.DataChangeMixin;
import duggelz.jape.FieldView;
import duggelz.jape.Structure;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class ChoiceView
extends Choice
implements FieldView,
ItemListener {
    private boolean suppressEvents = false;
    private String fieldName;
    private boolean modified = false;
    private String oldValue;
    private Structure struct;
    private DataChangeMixin mixin = new DataChangeMixin();

    public ChoiceView(String fieldName, Vector choices) {
        this.fieldName = fieldName;
        for (int idx = 0; idx < choices.size(); ++idx) {
            this.add((String)choices.elementAt(idx));
        }
        this.addItemListener(this);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getValue() {
        return this.getSelectedItem();
    }

    public void setStruct(Structure struct) {
        this.struct = struct;
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.suppressEvents) {
            return;
        }
        String newValue = this.getSelectedItem();
        this.commit(newValue);
        this.oldValue = newValue;
    }

    public void commit(String newValue) {
        String oldValue;
        if (this.struct != null && ((oldValue = this.struct.get(this.fieldName)) == null && newValue != null || oldValue != null && !oldValue.equals(newValue))) {
            this.modified = true;
            this.struct.set(this.fieldName, newValue);
            this.fireDataChangeEvent(new DataChangeEvent(this, this.oldValue, newValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        try {
            this.suppressEvents = true;
            String value = null;
            if (this.struct != null) {
                value = this.struct.get(this.fieldName);
            }
            if (value != null) {
                this.select(value);
            } else {
                this.select(0);
            }
            this.oldValue = value;
            this.modified = false;
        }
        finally {
            this.suppressEvents = false;
        }
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.mixin.addDataChangeListener(l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.mixin.removeDataChangeListener(l);
    }

    public void fireDataChangeEvent(DataChangeEvent e) {
        this.mixin.fireDataChangeEvent(e);
    }
}

