/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.RandomAccessFile;

public class SaveGame {
    public int thingCountOffset = 815;
    public int thingCount = 0;
    public int thingOffset = 819;
    public int thingDataLength = 28;
    public int otherThingDataLength = 7440;
    public int actorCount = 170;
    public int actorDataLength = 716;
    public int actorOffset = 0;
    public Actor[] actors = new Actor[this.actorCount];
    public int mercCount = 0;
    public int mercMaxCount = 18;
    public int mercDataLength = 2462;
    public int mercOffset = 0;
    public Mercenary[] mercs = new Mercenary[this.mercMaxCount];
    public String filename;
    public RandomAccessFile file;
    public int codeTableIdx;
    public int codeTableSubIdx;
    public int[] codeTable;

    public int[] findActorCodeTable(byte[] ciphertext) {
        for (int mainTable = 0; mainTable < 4; ++mainTable) {
            for (int subTable = 0; subTable < 57; ++subTable) {
                byte[] plaintext = JapeAlg.Decode(ciphertext, 8, JapeConst.CodeTables[mainTable][subTable]);
                if (plaintext[1] != 0 || plaintext[3] != 0 || plaintext[5] != 0 || plaintext[7] != 0) continue;
                int[] results = new int[]{mainTable, subTable};
                return results;
            }
        }
        return null;
    }

    public Actor getActor(int idx) {
        return this.actors[idx];
    }

    public Actor getActorByNick(String nick) {
        for (int idx = 0; idx < this.actorCount; ++idx) {
            Actor actor = this.actors[idx];
            if (actor == null || !actor.get("Nickname").equals(nick)) continue;
            return actor;
        }
        return null;
    }

    public Mercenary getMerc(int idx) {
        return this.mercs[idx];
    }

    public Mercenary getMercByNick(String nick) {
        for (int idx = 0; idx < this.mercCount; ++idx) {
            Mercenary merc = this.mercs[idx];
            if (merc == null || !merc.get("Nickname").equals(nick)) continue;
            return merc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String filename) throws IOException, FormatException {
        this.filename = filename;
        this.file = new RandomAccessFile(this.filename, "r");
        try {
            this.file.seek(this.thingCountOffset);
            this.thingCount = this.file.readByte() & 0xFF;
            this.actorOffset = this.thingOffset + this.thingCount * this.thingDataLength + this.otherThingDataLength;
            this.mercOffset = this.actorOffset + this.actorDataLength * this.actorCount;
            this.file.seek(this.actorOffset);
            byte[] rawData = new byte[16];
            this.file.readFully(rawData);
            int[] indexes = this.findActorCodeTable(rawData);
            if (indexes == null) {
                throw new FormatException();
            }
            this.codeTableIdx = indexes[0];
            this.codeTableSubIdx = indexes[1];
            this.codeTable = JapeConst.CodeTables[this.codeTableIdx][this.codeTableSubIdx];
            this.loadActors();
            this.loadMercs();
        }
        finally {
            this.file.close();
        }
    }

    public void loadActors() throws IOException {
        this.file.seek(this.actorOffset);
        for (int idx = 0; idx < this.actorCount; ++idx) {
            Actor actor;
            byte[] actorData = new byte[this.actorDataLength];
            this.file.readFully(actorData);
            this.actors[idx] = actor = new Actor(actorData, this.codeTable);
        }
    }

    public void loadMercs() throws IOException {
        this.file.seek(this.mercOffset);
        for (int mercIdx = 0; mercIdx < 18; ++mercIdx) {
            Mercenary merc;
            int adjustIdx;
            for (adjustIdx = 0; adjustIdx < 16; ++adjustIdx) {
                if (this.file.readByte() != 1) continue;
                this.file.seek(this.file.getFilePointer() - 1L);
                break;
            }
            if (adjustIdx == 16) break;
            byte[] mercData = new byte[this.mercDataLength];
            this.file.readFully(mercData);
            this.mercs[this.mercCount] = merc = new Mercenary(mercData, this.codeTable);
            ++this.mercCount;
            merc.adjustCount = adjustIdx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        this.file = new RandomAccessFile(this.filename, "rw");
        try {
            this.saveActors();
            this.saveMercs();
        }
        finally {
            this.file.close();
        }
    }

    public void saveActors() throws IOException {
        this.file.seek(this.actorOffset);
        for (int idx = 0; idx < this.actorCount; ++idx) {
            Actor actor = this.actors[idx];
            byte[] actorData = actor.encode(this.codeTable);
            this.file.write(actorData);
        }
    }

    public void saveMercs() throws IOException {
        this.file.seek(this.mercOffset);
        for (int idx = 0; idx < this.mercCount; ++idx) {
            Mercenary merc = this.mercs[idx];
            byte[] mercData = merc.encode(this.codeTable);
            for (int i = 0; i < merc.adjustCount; ++i) {
                this.file.writeByte(0);
            }
            this.file.write(mercData);
        }
    }

    public class FormatException
    extends Exception {
    }
}

