/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class ItemPanel
extends InsetPanel
implements DataChangeListener {
    private Frame parent;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private ItemDetailPanel itemDetailPanel;
    private boolean modified = false;
    private Actor actor;
    private Mercenary merc;
    private Vector views = new Vector();
    private ItemView currentView;
    private DataChangeMixin mixin = new DataChangeMixin();
    static final long serialVersionUID = 12469L;

    public ItemPanel(Frame parent) {
        super(new Insets(10, 10, 10, 10));
        this.parent = parent;
        this.setLayout(this.layout);
        this.constraint.anchor = 16;
        this.constraint.fill = 0;
        this.constraint.gridx = 0;
        this.constraint.gridheight = 1;
        this.constraint.gridwidth = 1;
        this.constraint.weightx = 1.0;
        this.constraint.insets = new Insets(0, 0, 0, 0);
        this.newRow();
        this.addItem(3);
        this.addSpace();
        this.addItem(0);
        this.newRow();
        this.addItem(4);
        this.addSpace();
        this.addItem(1);
        this.newRow();
        this.addItem(5);
        this.addSpace();
        this.addItem(2);
        this.newRow();
        this.addItem(6);
        this.newRow();
        this.addItem(11);
        this.addItem(15);
        this.addItem(7);
        this.newRow();
        this.addItem(12);
        this.addItem(16);
        this.addItem(8);
        this.newRow();
        this.addItem(13);
        this.addItem(17);
        this.addItem(9);
        this.newRow();
        this.addItem(14);
        this.addItem(18);
        this.addItem(10);
        this.newRow();
        this.itemDetailPanel = new ItemDetailPanel(this.parent);
        this.constraint.gridwidth = 3;
        this.constraint.weightx = 1.0;
        this.constraint.weighty = 1.0;
        this.add((Component)this.itemDetailPanel, this.constraint);
        this.itemDetailPanel.addDataChangeListener(this);
    }

    private void addComponent(int colwidth, Component component) {
        this.constraint.gridwidth = colwidth;
        this.add(component, this.constraint);
        this.constraint.gridx += colwidth;
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.mixin.addDataChangeListener(l);
    }

    private void addItem(int index) {
        final ItemView view = new ItemView(index);
        this.addComponent(1, view);
        this.views.addElement(view);
        view.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ItemPanel.this.doItemSelected(view);
            }
        });
    }

    private void addSpace() {
        ++this.constraint.gridx;
    }

    public void dataChanged(DataChangeEvent event) {
        FieldView view = (FieldView)event.getSource();
        String oldValue = event.getOldValue();
        String newValue = event.getNewValue();
        this.currentView.refresh();
        this.modified = true;
        this.fireDataChangeEvent(event);
    }

    public void doItemSelected(ItemView view) {
        int index = view.getIndex();
        this.currentView = view;
        Item item = null;
        if (this.merc != null) {
            item = this.merc.items[index];
        }
        this.itemDetailPanel.setItem(item);
    }

    public void fireDataChangeEvent(DataChangeEvent e) {
        this.mixin.fireDataChangeEvent(e);
    }

    public boolean isModified() {
        return this.itemDetailPanel.isModified();
    }

    private void newRow() {
        ++this.constraint.gridy;
        this.constraint.gridx = 0;
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.mixin.removeDataChangeListener(l);
    }

    public void setActor(Actor actor, Mercenary merc) {
        this.actor = actor;
        this.merc = merc;
        for (int idx = 0; idx < this.views.size(); ++idx) {
            ItemView view = (ItemView)this.views.elementAt(idx);
            view.setActor(merc);
        }
        this.modified = false;
        this.doItemSelected((ItemView)this.views.elementAt(0));
    }

    public void setModified(boolean modified) {
        this.itemDetailPanel.setModified(modified);
        this.modified = modified;
    }
}

