/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class ChoiceView
extends Choice
implements FieldView,
ItemListener,
KeyListener {
    private boolean suppressEvents = false;
    private String fieldName;
    private boolean modified = false;
    private String oldValue;
    private Structure struct;
    private DataChangeMixin mixin = new DataChangeMixin();
    private String suche;
    private Vector feld;
    private String vergleich;
    static final long serialVersionUID = 12469L;

    public ChoiceView(String fieldName, Vector choices) {
        this.fieldName = fieldName;
        for (int idx = 0; idx < choices.size(); ++idx) {
            this.add((String)choices.elementAt(idx));
        }
        this.addItemListener(this);
        this.addKeyListener(this);
        this.feld = choices;
        this.suche = new String();
        this.suche = "";
        this.vergleich = new String();
        this.vergleich = "";
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.mixin.addDataChangeListener(l);
    }

    public void commit(String newValue) {
        String oldValue;
        if (this.struct != null && ((oldValue = this.struct.get(this.fieldName)) == null && newValue != null || oldValue != null && !oldValue.equals(newValue))) {
            this.modified = true;
            this.struct.set(this.fieldName, newValue);
            this.fireDataChangeEvent(new DataChangeEvent(this, this.oldValue, newValue));
        }
    }

    public void fireDataChangeEvent(DataChangeEvent e) {
        this.mixin.fireDataChangeEvent(e);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getValue() {
        return this.getSelectedItem();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.suppressEvents) {
            return;
        }
        String newValue = this.getSelectedItem();
        this.commit(newValue);
        this.oldValue = newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        try {
            this.suppressEvents = true;
            String value = null;
            if (this.struct != null) {
                value = this.struct.get(this.fieldName);
            }
            if (value != null) {
                this.select(value);
            } else {
                this.select(0);
            }
            this.oldValue = value;
            this.modified = false;
            this.suche = "";
        }
        finally {
            this.suppressEvents = false;
        }
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.mixin.removeDataChangeListener(l);
    }

    public void setStruct(Structure struct) {
        this.struct = struct;
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.suche = "";
            return;
        }
        if (event.getKeyCode() == 8) {
            this.suche = this.suche.length() > 1 ? this.suche.substring(0, this.suche.length() - 1) : "";
            return;
        }
        this.suche = this.suche + event.getKeyChar();
        this.suche = this.suche.toLowerCase();
        for (int idx = 0; idx < this.feld.size(); ++idx) {
            this.vergleich = this.feld.elementAt(idx).toString();
            if (this.suche.length() < this.vergleich.length()) {
                this.vergleich = this.vergleich.substring(0, this.suche.length());
            }
            this.vergleich = this.vergleich.toLowerCase();
            if (!this.suche.equals(this.vergleich)) continue;
            this.select(idx);
            return;
        }
    }

    public void keyReleased(KeyEvent event) {
    }
}

