/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;

public class Actor
extends BasicStructure {
    public static final int NAME_OFFSET = 0;
    public static final int NAME_LENGTH = 60;
    public static final int NICK_OFFSET = 60;
    public static final int NICK_LENGTH = 20;
    public static final int MED_OFFSET = 261;
    public static final int STR_OFFSET = 296;
    public static final int LVL_INC_OFFSET = 298;
    public static final int HEALTH_INC_OFFSET = 299;
    public static final int AGI_INC_OFFSET = 300;
    public static final int DEX_INC_OFFSET = 301;
    public static final int WIS_INC_OFFSET = 302;
    public static final int MRK_INC_OFFSET = 303;
    public static final int MED_INC_OFFSET = 304;
    public static final int MEC_INC_OFFSET = 305;
    public static final int EXP_INC_OFFSET = 306;
    public static final int STR_INC_OFFSET = 307;
    public static final int LDR_INC_OFFSET = 308;
    public static final int KILLS_OFFSET = 310;
    public static final int KILLS_LENGTH = 2;
    public static final int ASSISTS_OFFSET = 312;
    public static final int ASSISTS_LENGTH = 2;
    public static final int SHOTS_FIRED_OFFSET = 314;
    public static final int SHOTS_FIRED_LENGTH = 2;
    public static final int SHOTS_HIT_OFFSET = 316;
    public static final int SHOTS_HIT_LENGTH = 2;
    public static final int BATTLES_OFFSET = 318;
    public static final int BATTLES_LENGTH = 2;
    public static final int WOUNDS_OFFSET = 320;
    public static final int WOUNDS_LENGTH = 2;
    public static final int MAX_HEALTH_OFFSET = 334;
    public static final int DEX_OFFSET = 335;
    public static final int PERSONALITY_OFFSET = 336;
    public static final int SKILL1_OFFSET = 337;
    public static final int EXP_OFFSET = 339;
    public static final int SKILL2_OFFSET = 340;
    public static final int LDR_OFFSET = 341;
    public static final int LVL_OFFSET = 352;
    public static final int MRK_OFFSET = 353;
    public static final int WIS_OFFSET = 355;
    public static final int AGI_OFFSET = 405;
    public static final int MEC_OFFSET = 411;
    public static final int CHECKSUM_OFFSET = 696;
    public static final int CHECKSUM_LENGTH = 4;
    public static Hashtable classFields = new Hashtable();

    public Actor(byte[] rawData, int[] table) {
        super(classFields);
        this.decode(rawData, table);
    }

    public void decode(byte[] ciphertext, int[] table) {
        this.data = JapeAlg.Decode(ciphertext, ciphertext.length, table);
    }

    public byte[] encode(int[] table) {
        this.recomputeChecksum();
        byte[] ciphertext = JapeAlg.Encode(this.data, this.data.length, table);
        return ciphertext;
    }

    public void recomputeChecksum() {
        int checksum = JapeAlg.ActorChecksum(this.data);
        this.setInt("Checksum", checksum);
    }

    static {
        classFields.put("Name", new StringField(0, 60));
        classFields.put("Nickname", new StringField(60, 20));
        classFields.put("Medical", new ByteField(261));
        classFields.put("Strength", new ByteField(296));
        classFields.put("Level Inc", new ByteField(298));
        classFields.put("Health Inc", new ByteField(299));
        classFields.put("Agility Inc", new ByteField(300));
        classFields.put("Dexterity Inc", new ByteField(301));
        classFields.put("Wisdom Inc", new ByteField(302));
        classFields.put("Marksmanship Inc", new ByteField(303));
        classFields.put("Medical Inc", new ByteField(304));
        classFields.put("Mechanical Inc", new ByteField(305));
        classFields.put("Explosives Inc", new ByteField(306));
        classFields.put("Strength Inc", new ByteField(307));
        classFields.put("Leadership Inc", new ByteField(308));
        classFields.put("Kills", new ShortField(310));
        classFields.put("Assists", new ShortField(312));
        classFields.put("Shots Fired", new ShortField(314));
        classFields.put("Shots Hit", new ShortField(316));
        classFields.put("Battles", new ShortField(318));
        classFields.put("Wounds", new ShortField(320));
        classFields.put("Max Health", new ByteField(334));
        classFields.put("Dexterity", new ByteField(335));
        classFields.put("Personality", new ByteField(336));
        classFields.put("Skill1", new ChoiceField(new ByteField(337), Skill.table));
        classFields.put("Explosives", new ByteField(339));
        classFields.put("Skill2", new ChoiceField(new ByteField(340), Skill.table));
        classFields.put("Leadership", new ByteField(341));
        classFields.put("Level", new ByteField(352));
        classFields.put("Marksmanship", new ByteField(353));
        classFields.put("Wisdom", new ByteField(355));
        classFields.put("Agility", new ByteField(405));
        classFields.put("Mechanical", new ByteField(411));
        classFields.put("Checksum", new IntField(696));
    }
}

