/******************************************************************************
*
* .SLF Utils
* Copyright (C) 2000 by Athman Boukhaoua
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
******************************************************************************/

#include "stdafx.h"
#include <stdio.h>
#include <string.h>
#include "common.h"
#include "slfworker.h"

SlfWorker::SlfWorker()
{
	memset(basedir, 0, sizeof(basedir));
	count = 0;
	LastError = 0;
	li = NULL;
	slffile = NULL;
}

SlfWorker::~SlfWorker()
{
	if (li)
	{
		delete [] li;
		li = NULL;
	}
	if (slffile)
	{
		fclose(slffile);
		slffile = NULL;
	}
}

bool SlfWorker::Load(char *filename)
{
// Open the slf File
	slffile = fopen(filename, "rb");
	if (slffile == (FILE *)NULL)
	{
		LastError = FILE_NOT_FOUND;
		return(FALSE);
	}
// Get the base directory of the archive
	char header[532];
	if (fread(header, 1, 532, slffile) != 532)
	{
		fclose(slffile);
		LastError = FILE_BUGGY;
		return(FALSE);
	}
	memcpy(&basedir, &header[256], 256);
// Get the number of files in the archive
	memcpy(&count, &header[512], 4);
// Load the dictionary temporarily into memory
	DWORD dictionarylength = count*280;
	char *dictionary = new char[dictionarylength];
	if (!dictionary)
	{
		fclose(slffile);
		LastError = MEMORY_ALLOCATION_FAILED;
		return(FALSE);
	}
	fseek(slffile, -(int)dictionarylength, SEEK_END);
	if (fread(dictionary, 1, dictionarylength, slffile) != dictionarylength)
	{
		delete [] dictionary;
		fclose(slffile);
		LastError = FILE_BUGGY;
		return(FALSE);
	}
// Parse the dictionary and store all important stuff into the *li array
	li = new ListItem[count];
	if (!li)
	{
		delete [] dictionary;
		fclose(slffile);
		LastError = MEMORY_ALLOCATION_FAILED;
		return(FALSE);
	}
	for (int i=0; i<count; i++)
	{
		memcpy(li[i].name, dictionary + 280*i, 256);
		char *tempc = strrchr(li[i].name, '\\');
		if (tempc)
		{
			char tempdir[256];
			tempc++;
			memcpy(&tempdir, li[i].name, tempc-li[i].name);
			tempdir[tempc-li[i].name] = 0;
			strcpy(li[i].name, tempc);
			strcpy(li[i].dir, basedir);
			strcat(li[i].dir, tempdir);
		}
		else
			strcpy(li[i].dir, basedir);
		memcpy(&li[i].pos, dictionary + 280*i + 256, 4);
		memcpy(&li[i].length, dictionary + 280*i + 260, 4);
	}	
// Everthing went fine, now kill the dictionary and return
	delete [] dictionary;
	return(TRUE);
}

bool SlfWorker::Extract(char *wildcard)
{
	char outname[256];
	FILE *outfile;
	int extracted=0;

	for (int i=0; i<count; i++)
	{
// Check whether the file is matched by the given wildcard
		if (WildcardMatch(li[i].name, wildcard))
		{
			CString test = li[i].name;
			strcpy(outname, li[i].name);
			outfile=fopen(outname, "wb");
			char *copybuf = new char[li[i].length];
			fseek(slffile, li[i].pos, SEEK_SET);
			fread(copybuf, 1, li[i].length, slffile);
			fwrite(copybuf, 1, li[i].length, outfile);
			delete [] copybuf;
			fclose(outfile);
			extracted++;
		}
	}

	if (!extracted)
		LastError = NO_FILES_EXTRACTED;
	return(extracted);
}

bool SlfWorker::WildcardMatch(char *n, char *w)
{
	if (!stricmp(n, w))
		return(TRUE);
// Q&D wildcard matching (How does one do the real stuff on Windows??!)
	if (!strcmp(w, "*") || !strcmp(w, "*.*"))
		return(TRUE);
	char *wext = strrchr(w, '.') + 1;
	char wname[256];
	memcpy(wname, w, wext-w-1); wname[wext-w-1] = 0;
	if (strchr(wext, '*'))
		return(FALSE);

	char *next = strrchr(n, '.') + 1;
	char nname[256];
	memcpy(nname, n, next-n-1); nname[next-n-1] = 0;

	if (!strcmp(wname, "*") && !stricmp(next, wext))
		return(TRUE);

	return(FALSE);
}

char *SlfWorker::GetItemName(int i)
{
	if (!li || i >= count)
	{
		LastError = NO_LIST_LOADED;
		return(NULL);
	}
	static char r[256];
	strcpy(r, li[i].name);
	return(r);
}

char *SlfWorker::GetItemDir(int i)
{
	if (!li || i >= count)
	{
		LastError = NO_LIST_LOADED;
		return(NULL);
	}
	static char r[256];
	strcpy(r, li[i].dir);
	return(r);
}

int SlfWorker::GetItemLength(int i)
{
	if (!li || i >= count)
	{
		LastError = NO_LIST_LOADED;
		return(FALSE);
	}
	return(li[i].length);
}

char *SlfWorker::LastErrorString()
{
	static char r[256];
	switch(LastError)
	{
	case FILE_NOT_FOUND:
		strcpy(r, "File not found");
		break;
	case FILE_BUGGY:
		strcpy(r, "File is buggy");
		break;
	case MEMORY_ALLOCATION_FAILED:
		strcpy(r, "Memory allocation failed");
		break;
	case NO_LIST_LOADED:
		strcpy(r, "No list loaded");
		break;
	case NO_FILES_EXTRACTED:
		strcpy(r, "No files extracted");
		break;
	case FILE_NOT_CREATED:
		strcpy(r, "File not created");
		break;
	default:
		strcpy(r, "unknown");
		break;
	}

	return(r);
}

