/******************************************************************************
*
* JA2 Voice Ripper
* Copyright (C) 1999 by Athman Boukhaoua
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
******************************************************************************/



// JA2VR.h : main header file for the JA2VR application
//

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"		// main symbols

/////////////////////////////////////////////////////////////////////////////
// CJA2VRApp:
// See JA2VR.cpp for the implementation of this class
//

#define BUFSIZE 450000
#define DIRSIZE 4000000

class CJA2VRApp : public CWinApp
{
public:
	CJA2VRApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CJA2VRApp)
	public:
	virtual BOOL InitInstance();
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(CJA2VRApp)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
protected:
	int GetSampleLength(LPSTR p);
	int GetSamplePos(LPSTR p);
	int GetNMerc(LPSTR p);
	int GetNSample(LPSTR p);
	char ProgramDir[256];
	int MercNPC;
	BOOL GetNextRIFF();
protected:
	int BaseAddress;
	LPSTR MercNamesBuf, SampleNamesBuf, NPCNamesBuf;
	LPSTR Protocol;
	char BProtocol[100000];
	LPSTR DirBuf;
	char BDirBuf[DIRSIZE];
	BYTE SoundBuf[BUFSIZE];
	CFile MercNames, SampleNames, NPCNames, InFile, OutFile;
	CString GetFilename(int nm, int ns);
	CString JA2Dir, SaveDir, CDDrive, Contains;
};


/////////////////////////////////////////////////////////////////////////////
