/******************************************************************************
*
* JA2 Voice Ripper
* Copyright (C) 1999 by Athman Boukhaoua
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
******************************************************************************/



// JA2VR.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "JA2VR.h"
#include "JA2VRDlg.h"
#include "ProgressDialog.h"
#include "ProtocolDialog.h"
#include <direct.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CProgressDialog pdlg;

/////////////////////////////////////////////////////////////////////////////
// CJA2VRApp

BEGIN_MESSAGE_MAP(CJA2VRApp, CWinApp)
	//{{AFX_MSG_MAP(CJA2VRApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CJA2VRApp construction

CJA2VRApp::CJA2VRApp()
{
	MercNamesBuf=NULL;
	SampleNamesBuf=NULL;
	NPCNamesBuf=NULL;
	Protocol=BProtocol;
	BaseAddress=0;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CJA2VRApp object

CJA2VRApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CJA2VRApp initialization

BOOL CJA2VRApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	CJA2VRDlg dlg;
	dlg.m_CDDrive = GetProfileString("JA2VoiceRipper", "CDDrive", "G:");
	dlg.m_SaveDir = GetProfileString("JA2VoiceRipper", "SaveDir", "C:\\spiele\\ja2\\waves");
	dlg.m_Contains = GetProfileString("JA2VoiceRipper", "Contains", "");
	dlg.m_JA2Dir = GetProfileString("JA2VoiceRipper", "JA2Dir", "C:\\spiele\\ja2");
	dlg.m_MercNPC = GetProfileInt("JA2VoiceRipper", "MercNPC", 0);
	int nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		CDDrive = dlg.m_CDDrive;
		SaveDir = dlg.m_SaveDir;
		Contains = dlg.m_Contains;
		JA2Dir = dlg.m_JA2Dir;
		MercNPC = dlg.m_MercNPC;
		_getcwd(ProgramDir, sizeof(ProgramDir));
		if (_chdir(CDDrive+CString("\\data")))
		{
			CString s;
			s.LoadString(IDS_NOPLAYCD);
			CString s2;
			s2.LoadString(IDS_ERROR);
			MessageBox(NULL, s, s2, MB_OK | MB_ICONSTOP | MB_TASKMODAL);
			return(FALSE);
		}
		if (MercNPC==2 && _chdir(JA2Dir+CString("\\data")))
		{
			CString s;
			s.LoadString(IDS_NOJA2DIR);
			CString s2;
			s2.LoadString(IDS_ERROR);
			MessageBox(NULL, s, s2, MB_OK | MB_ICONSTOP | MB_TASKMODAL);
			return(FALSE);
		}
		if (_chdir(SaveDir))
		{
			if (_mkdir(SaveDir))
			{
				CString s;
				s.LoadString(IDS_NOSAVEDIR);
				CString s2;
				s2.LoadString(IDS_ERROR);
				MessageBox(NULL, s, s2, MB_OK | MB_ICONSTOP | MB_TASKMODAL);
				return(FALSE);
			}
		}

		WriteProfileString("JA2VoiceRipper", "CDDrive", dlg.m_CDDrive);
		WriteProfileString("JA2VoiceRipper", "SaveDir", dlg.m_SaveDir);
		WriteProfileString("JA2VoiceRipper", "Contains", dlg.m_Contains);
		WriteProfileString("JA2VoiceRipper", "JA2Dir", dlg.m_JA2Dir);
		WriteProfileInt("JA2VoiceRipper", "MercNPC", dlg.m_MercNPC);

		_chdir(ProgramDir);
		switch(MercNPC)
		{
		case 0:
			if (MercNames.Open("mercnames2.txt", CFile::modeRead | CFile::typeBinary))
			{
				MercNamesBuf = new char[MercNames.GetLength()];
				MercNames.Read((LPVOID)MercNamesBuf, MercNames.GetLength());
			}
			else
			{
				MercNamesBuf = new char[1];
				MercNamesBuf[0] = 0;
			}
			if (SampleNames.Open("samplenames2.txt", CFile::modeRead | CFile::typeBinary))
			{
				SampleNamesBuf = new char[SampleNames.GetLength()];
				SampleNames.Read((LPVOID)SampleNamesBuf, SampleNames.GetLength());
			}
			else
			{
				SampleNamesBuf = new char[1];
				SampleNamesBuf[0] = 0;
			}
			break;
		case 1:
			if (MercNames.Open("mercnames2.txt", CFile::modeRead | CFile::typeBinary))
			{
				MercNamesBuf = new char[MercNames.GetLength()];
				MercNames.Read((LPVOID)MercNamesBuf, MercNames.GetLength());
			}
			else
			{
				MercNamesBuf = new char[1];
				MercNamesBuf[0] = 0;
			}
			SampleNamesBuf = new char[1];
			SampleNamesBuf[0] = 0;
			break;
		case 2:
			if (MercNames.Open("sndnames2.txt", CFile::modeRead | CFile::typeBinary))
			{
				MercNamesBuf = new char[MercNames.GetLength()];
				MercNames.Read((LPVOID)MercNamesBuf, MercNames.GetLength());
			}
			else
			{
				MercNamesBuf = new char[1];
				MercNamesBuf[0] = 0;
			}
			SampleNamesBuf = new char[1];
			SampleNamesBuf[0] = 0;
			break;
		default:
			return(FALSE);
			break;
		}

		switch(MercNPC)
		{
		case 0:
			InFile.Open(CDDrive+CString("\\data\\speech.slf"), CFile::modeRead | CFile::typeBinary);
			break;
		case 1:
			InFile.Open(CDDrive+CString("\\data\\npc_speech.slf"), CFile::modeRead | CFile::typeBinary);
			break;
		case 2:
			InFile.Open(JA2Dir+CString("\\data\\sounds.slf"), CFile::modeRead | CFile::typeBinary);
			break;
		default:
			return(FALSE);
			break;
		}
		// Was file opened?
		if (InFile.m_hFile == (UINT)CFile::hFileNull)
		{
			if (MercNamesBuf[0]) MercNames.Close();
			delete [] MercNamesBuf;
			CString s;
			s.LoadString(IDS_NOINPUTFILE);
			CString s2;
			s2.LoadString(IDS_ERROR);
			MessageBox(NULL, s, s2, MB_OK | MB_ICONSTOP | MB_TASKMODAL);
			return(FALSE);
		}

		// Check for free disk space
		DWORD SectorsPerCluster, BytesPerSector, NumberOfFreeClusters, TotalNumberOfClusters;
		GetDiskFreeSpace(SaveDir.Left(3), &SectorsPerCluster, &BytesPerSector, &NumberOfFreeClusters, &TotalNumberOfClusters);
		if (NumberOfFreeClusters*SectorsPerCluster*BytesPerSector < InFile.GetLength())
		{
			InFile.Close();
			if (MercNamesBuf[0]) MercNames.Close();
			delete [] MercNamesBuf;
			delete [] SampleNamesBuf;
			CString s;
			s.LoadString(IDS_NODISKSPACE);
			CString s2;
			s2.LoadString(IDS_ERROR);
			MessageBox(NULL, s, s2, MB_OK | MB_ICONSTOP);
			return(FALSE);
		}

		switch(MercNPC)
		{
		case 0:
			InFile.Seek(-3226440L, CFile::end);
			DirBuf = BDirBuf;
			ZeroMemory(DirBuf, DIRSIZE);
			InFile.Read(BDirBuf, 3226440L);
			break;
		case 1:
			InFile.Seek(-1503320L, CFile::end);
			DirBuf = BDirBuf;
			ZeroMemory(DirBuf, DIRSIZE);
			InFile.Read(BDirBuf, 1503320L);
			break;
		case 2:
			InFile.Seek(-101080L, CFile::end);
			DirBuf = BDirBuf;
			ZeroMemory(DirBuf, DIRSIZE);
			InFile.Read(BDirBuf, 101080L);
			break;
		default:
			return(FALSE);
			break;
		}

		int SamplePos, SampleLength;
		int nMerc=0, nSample=0;
		int bspos;
		char ts[256];
		CString Filename;
		pdlg.Create(IDD_PROGRESS);
		if (MercNPC == 2)
			pdlg.m_ProgressCtrl.SetRange(0, 358);
		else if (MercNPC == 1)
			pdlg.m_ProgressCtrl.SetRange(0, 2602);
		else
			pdlg.m_ProgressCtrl.SetRange(0, 5817);

		for (int n=0;;)
		{
			SamplePos = GetSamplePos(DirBuf);
			SampleLength = GetSampleLength(DirBuf);
			n++;
			if (!(n&15))
			{
				sprintf(ts, "%d", n);
				pdlg.m_Progress = CString(ts);
				pdlg.m_ProgressCtrl.SetPos(n);
				pdlg.UpdateData(FALSE);
				SendMessage(pdlg, WM_PAINT, 0, 0);
			}
			if (MercNPC == 0 || MercNPC == 1)
			{
				nMerc = GetNMerc(DirBuf);
				nSample = GetNSample(DirBuf);
				DirBuf += 280;
				if (SamplePos==-1 || SampleLength==-1)
					break;
				if (MercNPC != 2 && (nMerc==-1 || nSample==-1))
					continue;
				if (!SamplePos || !SampleLength)
					continue;
				Filename = GetFilename(nMerc, nSample);
			}
			else if (MercNPC == 2)
			{
				Filename = strcpy(ts, DirBuf);
				if ((bspos = Filename.Find('\\')) != -1)
					Filename = Filename.Right(Filename.GetLength()-bspos-1);
				DirBuf += 280;
				if (SamplePos==-1 || SampleLength==-1)
					break;
				if (!SamplePos || !SampleLength)
					continue;
			}

			if (!strstr(Filename, Contains))
				continue;

			if (SetFilePointer((HANDLE)InFile.m_hFile, SamplePos, NULL, (DWORD)CFile::begin) == -1)
				break;
			/*try
			{
				InFile.Seek(SamplePos, CFile::begin);
			} catch (CFileException exp)
			{
				strcpy(ts, "jhjh");
				break;
			}*/
			InFile.Read(SoundBuf, SampleLength);
			OutFile.Open(SaveDir+CString("\\")+Filename, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary);
			try
			{
				OutFile.Write((LPVOID)SoundBuf, SampleLength);
			} catch (CFileException exp)
			{
				pdlg.DestroyWindow();
				InFile.Close();
				if (MercNamesBuf[0]) MercNames.Close();
				delete [] MercNamesBuf;
				delete [] SampleNamesBuf;
				CString s;
				s.LoadString(IDS_UNABLETOWRITE);
				CString s2;
				s2.LoadString(IDS_ERROR);
				MessageBox(NULL, s, s2, MB_OK | MB_ICONSTOP);
				return(FALSE);
			}
			OutFile.Close();
		}

		pdlg.DestroyWindow();
		InFile.Close();
		if (MercNamesBuf[0]) MercNames.Close();
		delete [] MercNamesBuf;
		delete [] SampleNamesBuf;
	}

	return FALSE;
}

CString CJA2VRApp::GetFilename(int nm, int ns)
{
	int n, rval;
	char merc[256], sample[256];
	LPSTR ts;

	if (!MercNamesBuf)
		return(CString(""));
	if (!SampleNamesBuf)
		return(CString(""));

	ts=MercNamesBuf;
	for (;;)
	{
		rval = sscanf(ts, "%d", &n);
		if (!rval || rval == EOF)
		{
			sprintf(merc, "_person%03d", nm);
			break;
		}
		if (n == nm)
		{
			// Number Found
			ts = strchr(ts, ' ')+1;
			rval = sscanf(ts, "%s", merc);
			if (!rval)
			{
				sprintf(merc, "_person%03d", nm);
				break;
			}
			break;
		}
		ts = strchr(ts, '\r')+1;
		// if EOF return standard name like "merc004" etc.
		if (ts == (LPSTR)1)
		{
			sprintf(merc, "_person%03d", nm);
			break;
		}
	}
	strcat(merc, "_");

	if (MercNPC == 1)
	{
		sprintf(sample, "%03d", ns);
		return(CString(merc)+CString(sample)+CString(".wav"));
	}

	ts=SampleNamesBuf;
	for (;;)
	{
		rval = sscanf(ts, "%d", &n);
		if (!rval || rval == EOF)
		{
			sprintf(sample, "%03d", ns);
			break;
		}
		if (n == ns)
		{
			// Number Found
			ts = strchr(ts, ' ')+1;
			rval = sscanf(ts, "%s", sample);
			if (!rval)
			{
				sprintf(sample, "%03d", ns);
				break;
			}
			break;
		}
		ts = strchr(ts, '\r')+1;
		// if EOF return standard name like "merc004" etc.
		if (ts == (LPSTR)1)
		{
			sprintf(sample, "%03d", ns);
			break;
		}
	}
	return(CString(merc)+CString(sample)+CString(".wav"));
}

int CJA2VRApp::GetSamplePos(LPSTR p)
{
	if (!*p)
		return(-1);
	if (!memcmp(p, "\0", 1))
		return(0);
	LPINT np = (LPINT)(p+256);
	return(*np);
}

int CJA2VRApp::GetSampleLength(LPSTR p)
{
	if (!*p)
		return(-1);
	if (!memcmp(p, "\0", 1))
		return(0);
	LPINT np = (LPINT)(p+260);
	return(*np);
}

int CJA2VRApp::GetNMerc(LPSTR p)
{
	if (!*p)
		return(-1);
	if (memcmp(p+8, "WAV", 3))
		return(0);
	char ts[10];
	memcpy(ts, p, 3);
	ts[3] = 0;
	if (!isdigit(ts[0]) || !isdigit(ts[1]) || !isdigit(ts[2]))
		return(-1);
	return(atoi(ts));
}

int CJA2VRApp::GetNSample(LPSTR p)
{
	if (!*p)
		return(-1);
	if (memcmp(p+8, "WAV", 3))
		return(0);
	char ts[10];
	memcpy(ts, p+4, 3);
	ts[3] = 0;
	if (!isdigit(ts[0]) || !isdigit(ts[1]) || !isdigit(ts[2]))
		return(-1);
	return(atoi(ts));
}
