/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Vector;

public class ItemDetailPanel
extends InsetPanel
implements DataChangeListener {
    private GridBagLayout layout = new GridBagLayout();
    private Frame parent;
    private GridBagConstraints constraint = new GridBagConstraints();
    private boolean modified = false;
    private Item item;
    private Vector views = new Vector();
    private Vector ammoComponents = new Vector();
    private Vector attachmentComponents = new Vector();
    private Vector moneyComponents = new Vector();
    private ChoiceView idView;
    private NumberView quantityView;
    private Label itemPctLabel;
    private NumberView[] itemPctViews = new NumberView[6];
    private Label ammoIdLabel;
    private ChoiceView ammoIdView;
    private Label ammoQuantityLabel;
    private NumberView ammoQuantityView;
    private Label ammoVarietyLabel;
    private NumberView ammoVarietyView;
    private Label ammoPctLabel;
    private NumberView ammoPctView;
    private ChoiceView[] attachmentIdViews = new ChoiceView[4];
    private NumberView[] attachmentPctViews = new NumberView[4];
    private Label moneyValueLabel;
    private NumberView moneyValueView;
    private DataChangeMixin mixin = new DataChangeMixin();
    private NumberView weightView;
    static final long serialVersionUID = 12469L;

    public ItemDetailPanel(Frame parent) {
        super(new Insets(10, 10, 10, 10));
        int idx;
        this.parent = parent;
        this.setLayout(this.layout);
        this.constraint.anchor = 16;
        this.constraint.fill = 0;
        this.constraint.gridx = 0;
        this.constraint.gridheight = 1;
        this.constraint.gridwidth = 1;
        this.constraint.insets = new Insets(0, 0, 0, 0);
        this.newRow();
        this.addText(1, "Item");
        this.idView = this.addItemView(6, "Item ID", ItemExemplar.nameList);
        this.newRow();
        this.addText(1, "Anzahl der Items");
        this.quantityView = this.addByteView(1, "Quantity");
        this.newRow();
        this.itemPctLabel = this.addText(1, "Item %");
        for (idx = 0; idx < 6; ++idx) {
            this.itemPctViews[idx] = this.addByteView(1, "Item " + (idx + 1) + " %");
        }
        this.newRow();
        this.ammoIdLabel = this.addText(1, "Munition");
        this.ammoComponents.addElement(this.ammoIdLabel);
        this.ammoIdView = this.addItemView(6, "Ammo ID", ItemExemplar.ammoNameList);
        this.ammoComponents.addElement(this.ammoIdView);
        this.newRow();
        this.ammoQuantityLabel = this.addText(1, "Kugelzahl");
        this.ammoComponents.addElement(this.ammoQuantityLabel);
        this.ammoQuantityView = this.addByteView(1, "Ammo Quantity");
        this.ammoComponents.addElement(this.ammoQuantityView);
        this.newRow();
        this.ammoVarietyLabel = this.addText(1, "Munition Variet\u00e4t");
        this.ammoComponents.addElement(this.ammoVarietyLabel);
        this.ammoVarietyView = this.addByteView(1, "Ammo Variety");
        this.ammoComponents.addElement(this.ammoVarietyView);
        this.newRow();
        this.ammoPctLabel = this.addText(1, "Munitionszustand %");
        this.ammoComponents.addElement(this.ammoPctLabel);
        this.ammoPctView = this.addByteView(1, "Ammo %");
        this.ammoComponents.addElement(this.ammoPctView);
        for (idx = 0; idx < 4; ++idx) {
            NumberView pctView;
            ChoiceView view;
            String str = "Erweiterung " + (idx + 1);
            String str2 = "Attachment " + (idx + 1);
            this.newRow();
            Label label = this.addText(1, str);
            this.attachmentComponents.addElement(label);
            this.attachmentIdViews[idx] = view = this.addItemView(6, str2 + " ID", ItemExemplar.attachmentNameList);
            this.attachmentComponents.addElement(view);
            this.attachmentPctViews[idx] = pctView = this.addByteView(1, str2 + " %");
            this.attachmentComponents.addElement(pctView);
            Label pctLabel = this.addText(1, "%");
            this.attachmentComponents.addElement(pctLabel);
        }
        this.newRow();
        this.addText(1, "Gewicht (x 0.1 kg)");
        this.weightView = this.addByteView(1, "Weight");
        this.newRow();
        this.moneyValueLabel = this.addText(1, "Geldwert");
        this.moneyComponents.addElement(this.moneyValueLabel);
        this.moneyValueView = this.addShortView(2, "Money Value");
        this.moneyComponents.addElement(this.moneyValueView);
        this.newRow();
        this.constraint.fill = 1;
        this.constraint.weightx = 1.0;
        this.constraint.weighty = 1.0;
        this.addComponent(0, new Label());
    }

    public NumberView addByteView(int colwidth, String statField) {
        return this.addNumberView(1, statField, 3);
    }

    private void addComponent(int colwidth, Component component) {
        this.constraint.gridwidth = colwidth;
        this.add(component, this.constraint);
        this.constraint.gridx += colwidth;
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.mixin.addDataChangeListener(l);
    }

    public ChoiceView addItemView(int colwidth, String statField, Vector statChoices) {
        ChoiceView view = new ChoiceView(statField, statChoices);
        this.constraint.fill = 2;
        this.addComponent(colwidth, view);
        this.views.addElement(view);
        view.addDataChangeListener(this);
        return view;
    }

    private NumberView addNumberView(int colwidth, String statField, int charWidth) {
        NumberView view = new NumberView(statField, charWidth);
        this.constraint.fill = 0;
        this.addComponent(colwidth, view);
        this.views.addElement(view);
        view.addDataChangeListener(this);
        return view;
    }

    public NumberView addShortView(int colwidth, String statField) {
        return this.addNumberView(1, statField, 3);
    }

    private Label addText(int colwidth, String text) {
        return this.addText(colwidth, text, 0);
    }

    private Label addText(int colwidth, String text, int align) {
        Label label = new Label(text, align);
        this.constraint.fill = 2;
        this.addComponent(colwidth, label);
        return label;
    }

    public void dataChanged(DataChangeEvent event) {
        block18: {
            String newValue;
            String oldValue;
            FieldView view;
            block19: {
                block17: {
                    view = (FieldView)event.getSource();
                    oldValue = event.getOldValue();
                    newValue = event.getNewValue();
                    if (this.item == null) {
                        return;
                    }
                    if (view != this.idView) break block17;
                    if (oldValue == null || oldValue == "") {
                        oldValue = "Nichts";
                    }
                    if (newValue == null || newValue == "") {
                        newValue = "Nichts";
                    }
                    if (oldValue.equals("Nichts") && !newValue.equals("Nichts")) {
                        this.quantityView.setText("1");
                        this.itemPctViews[0].setEnabled(true);
                        this.itemPctViews[0].setText("100");
                    } else if (newValue.equals("Nichts")) {
                        this.quantityView.setText("0");
                        this.itemPctViews[0].setEnabled(true);
                        this.itemPctViews[0].setText("0");
                    }
                    ItemExemplar exemplar = this.item.getExemplar();
                    if (exemplar.category == 1) {
                        this.quantityView.setText("1");
                    } else if (exemplar.category == 4) {
                        int quantity = this.item.getInt("Quantity");
                        for (int idx = 0; idx < quantity; ++idx) {
                            this.itemPctViews[idx].setEnabled(true);
                            this.itemPctViews[idx].setText(String.valueOf(exemplar.ammoCapacity));
                        }
                    }
                    this.setEnabledAll();
                    break block18;
                }
                if (view != this.ammoIdView) break block19;
                if (oldValue == null || oldValue == "") {
                    oldValue = "Nichts";
                }
                if (newValue == null || newValue == "") {
                    newValue = "Nichts";
                }
                if (newValue.equals("Nichts") || newValue.equals(oldValue)) break block18;
                int ammoId = this.item.getInt("Ammo ID");
                ItemExemplar exemplar = (ItemExemplar)ItemExemplar.exemplarTable.get(new Integer(ammoId));
                System.err.println(String.valueOf(exemplar.ammoVariety));
                this.ammoVarietyView.setText(String.valueOf(exemplar.ammoVariety));
                this.ammoQuantityView.setText(String.valueOf(exemplar.ammoCapacity));
                this.ammoPctView.setText("100");
                break block18;
            }
            if (view == this.quantityView) {
                this.setEnabledAll();
            } else {
                for (int idx = 0; idx < this.attachmentIdViews.length; ++idx) {
                    if (view != this.attachmentIdViews[idx]) continue;
                    if (oldValue == null || oldValue == "") {
                        oldValue = "Nichts";
                    }
                    if (newValue == null || newValue == "") {
                        newValue = "Nichts";
                    }
                    if (!oldValue.equals("Nichts") || newValue.equals("Nichts")) break;
                    this.attachmentPctViews[idx].setText("100");
                    break;
                }
            }
        }
        this.modified = true;
        this.fireDataChangeEvent(event);
    }

    public void fireDataChangeEvent(DataChangeEvent e) {
        this.mixin.fireDataChangeEvent(e);
    }

    public boolean isModified() {
        return this.modified;
    }

    private void newRow() {
        ++this.constraint.gridy;
        this.constraint.gridx = 0;
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.mixin.removeDataChangeListener(l);
    }

    public void setEnabled(Vector views, boolean enabled) {
        Enumeration e = views.elements();
        while (e.hasMoreElements()) {
            Component view = (Component)e.nextElement();
            view.setEnabled(enabled);
        }
    }

    public void setEnabledAll() {
        if (this.item == null) {
            return;
        }
        ItemExemplar exemplar = this.item.getExemplar();
        switch (exemplar.category) {
            case 1: {
                this.setEnabled(this.ammoComponents, true);
                this.setEnabled(this.attachmentComponents, true);
                this.setEnabled(this.moneyComponents, false);
                break;
            }
            case 9: {
                this.setEnabled(this.ammoComponents, false);
                this.setEnabled(this.attachmentComponents, true);
                this.setEnabled(this.moneyComponents, false);
                break;
            }
            case 18: {
                this.setEnabled(this.ammoComponents, false);
                this.setEnabled(this.attachmentComponents, false);
                this.setEnabled(this.moneyComponents, true);
                break;
            }
            default: {
                this.setEnabled(this.ammoComponents, false);
                this.setEnabled(this.attachmentComponents, false);
                this.setEnabled(this.moneyComponents, false);
            }
        }
        int quantity = this.item.getInt("Quantity");
        for (int idx = 0; idx < 6; ++idx) {
            this.itemPctViews[idx].setEnabled(idx < quantity);
        }
        if (quantity == 0) {
            this.itemPctLabel.setEnabled(false);
        } else {
            this.itemPctLabel.setEnabled(true);
        }
        if (exemplar.category == 4) {
            this.itemPctLabel.setText("Number of Rounds");
        } else {
            this.itemPctLabel.setText("Item %");
        }
    }

    public void setItem(Item item) {
        this.item = item;
        Enumeration e = this.views.elements();
        while (e.hasMoreElements()) {
            FieldView view = (FieldView)e.nextElement();
            view.setStruct(item);
            view.refresh();
        }
        this.setEnabledAll();
        this.modified = false;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }
}

