/*
 * Decompiled with CFR 0.152.
 */
package duggelz.jape;

import duggelz.jape.Actor;
import duggelz.jape.BasicStructure;
import duggelz.jape.ChoiceView;
import duggelz.jape.DataChangeEvent;
import duggelz.jape.DataChangeListener;
import duggelz.jape.DataChangeMixin;
import duggelz.jape.FieldView;
import duggelz.jape.InsetPanel;
import duggelz.jape.Mercenary;
import duggelz.jape.NumberView;
import duggelz.jape.Skill;
import duggelz.jape.TextView;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Vector;

public class StatPanel
extends InsetPanel
implements DataChangeListener {
    private Frame parent;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private boolean modified = false;
    private Actor actor;
    private Mercenary merc;
    private Vector views = new Vector();
    private DataChangeMixin mixin = new DataChangeMixin();

    public StatPanel(Frame parent) {
        super(new Insets(10, 10, 10, 10));
        this.parent = parent;
        this.setLayout(this.layout);
        this.constraint.anchor = 16;
        this.constraint.fill = 0;
        this.constraint.gridx = 0;
        this.constraint.gridheight = 1;
        this.constraint.gridwidth = 1;
        this.constraint.insets = new Insets(0, 0, 0, 0);
        this.addStringStat("Name", "Name", 30);
        this.addStringStat("Nickname", "Nickname", 30);
        this.newRow();
        this.addText(1, "Health", 0);
        this.addNumberView(1, "Health", 3);
        this.addText(1, "/", 1);
        this.addNumberView(1, "Max Health", 3);
        this.addText(1, "(+", 2);
        this.addNumberView(1, "Health Inc", 3);
        this.addText(1, ")", 0);
        this.addByteStat("Energy", "Energy");
        this.addByteStat("Morale", "Morale");
        this.addIncStat("Agility", "Agility", "Agility Inc");
        this.addIncStat("Dexterity", "Dexterity", "Dexterity Inc");
        this.addIncStat("Strength", "Strength", "Strength Inc");
        this.addIncStat("Leadership", "Leadership", "Leadership Inc");
        this.addIncStat("Wisdom", "Wisdom", "Wisdom Inc");
        this.addIncStat("Marksmanship", "Marksmanship", "Marksmanship Inc");
        this.addIncStat("Explosives", "Explosives", "Explosives Inc");
        this.addIncStat("Mechanical", "Mechanical", "Mechanical Inc");
        this.addIncStat("Medical", "Medical", "Medical Inc");
        this.addIncStat("Exp Lvl", "Level", "Level Inc");
        this.addChoiceStat("Skill1", "Skill1", Skill.list);
        this.addChoiceStat("Skill2", "Skill2", Skill.list);
        this.addShortStat("Kills", "Kills");
        this.addShortStat("Assists", "Assists");
        this.addShortStat("Shots Fired", "Shots Fired");
        this.addShortStat("Shots Hit", "Shots Hit");
        this.addShortStat("Battles", "Battles");
        this.addShortStat("Times Wounded", "Wounds");
        this.newRow();
        this.constraint.fill = 1;
        this.constraint.weightx = 1.0;
        this.constraint.weighty = 1.0;
        this.addComponent(0, new Label());
    }

    private void newRow() {
        ++this.constraint.gridy;
        this.constraint.gridx = 0;
    }

    private void addComponent(int colwidth, Component component) {
        this.constraint.gridwidth = colwidth;
        this.add(component, this.constraint);
        this.constraint.gridx += colwidth;
    }

    private void addTextView(int colwidth, String statField, int charWidth) {
        TextView view = new TextView(statField, charWidth);
        this.addComponent(colwidth, view);
        this.views.addElement(view);
        view.addDataChangeListener(this);
    }

    private void addNumberView(int colwidth, String statField, int charWidth) {
        NumberView view = new NumberView(statField, charWidth);
        this.addComponent(colwidth, view);
        this.views.addElement(view);
        view.addDataChangeListener(this);
    }

    private void addText(int colwidth, String text, int align) {
        Label label = new Label(text, align);
        this.addComponent(colwidth, label);
    }

    public void addByteStat(String statTitle, String statField) {
        this.newRow();
        this.addText(1, statTitle, 0);
        this.addNumberView(1, statField, 3);
    }

    public void addIncStat(String statTitle, String statField, String incStatField) {
        this.newRow();
        this.addText(1, statTitle, 0);
        this.addNumberView(1, statField, 3);
        this.addText(1, "(+", 2);
        this.addNumberView(1, incStatField, 3);
        this.addText(1, ")", 0);
    }

    public void addShortStat(String statTitle, String statField) {
        this.addByteStat(statTitle, statField);
    }

    public void addStringStat(String statTitle, String statField, int charWidth) {
        this.newRow();
        this.addText(1, statTitle, 0);
        this.addNumberView(0, statField, charWidth);
    }

    public void addChoiceStat(String statTitle, String statField, Vector statChoices) {
        this.newRow();
        this.addText(1, statTitle, 0);
        ChoiceView view = new ChoiceView(statField, statChoices);
        this.addComponent(0, view);
        this.views.addElement(view);
        view.addDataChangeListener(this);
    }

    public void setActor(Actor actor, Mercenary merc) {
        BasicStructure struct;
        this.actor = actor;
        this.merc = merc;
        if (this.merc != null) {
            struct = this.merc;
            struct.chain(this.actor);
        } else {
            struct = this.actor;
        }
        Enumeration e = this.views.elements();
        while (e.hasMoreElements()) {
            FieldView view = (FieldView)e.nextElement();
            view.setStruct(struct);
            view.refresh();
        }
        this.modified = false;
    }

    public void dataChanged(DataChangeEvent event) {
        FieldView view = (FieldView)event.getSource();
        String oldValue = event.getOldValue();
        String newValue = event.getNewValue();
        if (this.actor == null) {
            return;
        }
        this.modified = true;
        this.fireDataChangeEvent(event);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.mixin.addDataChangeListener(l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.mixin.removeDataChangeListener(l);
    }

    public void fireDataChangeEvent(DataChangeEvent e) {
        this.mixin.fireDataChangeEvent(e);
    }
}

