/*
 * Decompiled with CFR 0.152.
 */
package duggelz.jape;

import duggelz.jape.InsetPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;

public class OptionDialog
extends Dialog {
    public static final int DEFAULT_OPTION = -1;
    public static final int OK_ONLY_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int CLOSED_OPTION = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    private int optionType;
    private int messageType;
    private int value = -1;

    public OptionDialog(Frame parent, Object message, String title, int optionType, int messageType) {
        super(parent, title, true);
        Button button;
        this.optionType = optionType;
        this.messageType = messageType;
        this.value = -1;
        Panel body = new Panel();
        body.setLayout(new BorderLayout());
        this.add(body);
        InsetPanel textPanel = new InsetPanel(5, 5, 5, 5);
        textPanel.setLayout(new GridLayout(0, 1));
        textPanel.setBackground(SystemColor.text);
        String messageStr = message.toString();
        StringTokenizer st = new StringTokenizer(messageStr, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            Label label = new Label(line, 0);
            textPanel.add(label);
        }
        InsetPanel buttonPanel = new InsetPanel(0, 5, 0, 5);
        buttonPanel.setLayout(new FlowLayout());
        if (this.optionType == -1 || this.optionType == 2) {
            button = new Button("OK");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionDialog.this.setValue(0);
                }
            });
            buttonPanel.add(button);
        }
        if (this.optionType == 0 || this.optionType == 1) {
            button = new Button("Yes");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionDialog.this.setValue(0);
                }
            });
            buttonPanel.add(button);
        }
        if (this.optionType == 0 || this.optionType == 1) {
            button = new Button("No");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionDialog.this.setValue(1);
                }
            });
            buttonPanel.add(button);
        }
        if (this.optionType == 2 || this.optionType == 1) {
            button = new Button("Cancel");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionDialog.this.setValue(2);
                }
            });
            buttonPanel.add(button);
        }
        body.add((Component)buttonPanel, "South");
        body.add((Component)textPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                OptionDialog.this.dispose();
            }
        });
        this.addNotify();
        this.pack();
        if (parent != null) {
            Point parentLoc = parent.getLocation();
            Dimension parentSize = parent.getSize();
            Dimension size = this.getSize();
            Point loc = new Point(parentLoc.x + (parentSize.width - size.width) / 2, parentLoc.y + (parentSize.height - size.height) / 2);
            this.setLocation(loc);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.dispose();
    }

    public static void showMessageDialog(Frame parent, Object message, String title, int messageType) {
        OptionDialog dialog = new OptionDialog(parent, message, title, -1, messageType);
        dialog.show();
    }

    public static int showConfirmDialog(Frame parent, Object message, String title, int optionType, int messageType) {
        OptionDialog dialog = new OptionDialog(parent, message, title, optionType, messageType);
        dialog.show();
        return dialog.getValue();
    }
}

