/*
 * Decompiled with CFR 0.152.
 */
package duggelz.jape;

import duggelz.jape.DataChangeEvent;
import duggelz.jape.DataChangeListener;
import duggelz.jape.DataChangeMixin;
import duggelz.jape.FieldView;
import duggelz.jape.Structure;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class NumberView
extends TextField
implements FieldView,
TextListener {
    private boolean suppressEvents = false;
    private String fieldName;
    private boolean modified = false;
    private String oldValue;
    private Structure struct;
    private DataChangeMixin mixin = new DataChangeMixin();

    public NumberView(String fieldName, int length) {
        super(length);
        this.fieldName = fieldName;
        this.addTextListener(this);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getValue() {
        return this.getText();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setStruct(Structure struct) {
        this.struct = struct;
    }

    public void textValueChanged(TextEvent event) {
        if (this.suppressEvents) {
            return;
        }
        String newValue = this.getText();
        try {
            if (newValue.equals("")) {
                newValue = "0";
            }
            this.commit(newValue);
            this.oldValue = newValue;
        }
        catch (NumberFormatException xcptn) {
            this.setText(this.oldValue);
        }
    }

    public void commit(String newValue) {
        String oldValue;
        if (this.struct != null && ((oldValue = this.struct.get(this.fieldName)) == null && newValue != null || oldValue != null && !oldValue.equals(newValue))) {
            this.modified = true;
            this.struct.set(this.fieldName, newValue);
            this.fireDataChangeEvent(new DataChangeEvent(this, this.oldValue, newValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        try {
            this.suppressEvents = true;
            String value = null;
            if (this.struct != null) {
                value = this.struct.get(this.fieldName);
            }
            if (value != null) {
                this.setText(value);
            } else {
                this.setText("");
            }
            this.oldValue = value;
            this.modified = false;
        }
        finally {
            this.suppressEvents = false;
        }
    }

    public String toString() {
        String s = "NumberView[suppressEvents = " + this.suppressEvents + "," + "fieldName = " + this.fieldName + "," + "modified = " + this.modified + "," + "oldValue = " + this.oldValue + "," + "struct = " + this.struct + "]";
        return s;
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.mixin.addDataChangeListener(l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.mixin.removeDataChangeListener(l);
    }

    public void fireDataChangeEvent(DataChangeEvent e) {
        this.mixin.fireDataChangeEvent(e);
    }
}

