/*
 * Decompiled with CFR 0.152.
 */
package duggelz.jape;

import duggelz.jape.Actor;
import duggelz.jape.DataChangeEvent;
import duggelz.jape.DataChangeListener;
import duggelz.jape.ItemPanel;
import duggelz.jape.JapeAbout;
import duggelz.jape.Mercenary;
import duggelz.jape.OptionDialog;
import duggelz.jape.SaveGame;
import duggelz.jape.StatPanel;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class JapeFrame
extends Frame
implements DataChangeListener {
    private static final int DEFAULT_WIDTH = 450;
    private static final int DEFAULT_HEIGHT = 450;
    private GridBagLayout layout = new GridBagLayout();
    private List actorList;
    private StatPanel statPanel;
    private ItemPanel itemPanel;
    private MenuBar menuBar;
    private Menu fileMenu;
    private MenuItem openItem;
    private MenuItem saveItem;
    private MenuItem closeItem;
    private MenuItem quitItem;
    private Menu helpMenu;
    private MenuItem aboutItem;
    private SaveGame saveGame;
    private boolean saveGameModified;
    private Actor currentActor;
    private Mercenary currentMerc;
    private String currentDir = System.getProperty("user.dir");

    public JapeFrame() {
        super("JAPE");
        this.createMenuBar();
        Panel body = new Panel();
        body.setLayout(this.layout);
        this.add("Center", body);
        this.actorList = new List();
        this.actorList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JapeFrame.this.doSelectActor();
            }
        });
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 1;
        c1.gridx = 0;
        c1.gridy = 0;
        c1.weighty = 1.0;
        c1.weightx = 0.0;
        body.add((Component)this.actorList, c1);
        this.statPanel = new StatPanel(this);
        this.statPanel.addDataChangeListener(this);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        c2.anchor = 18;
        c2.gridx = 1;
        c2.gridy = 0;
        c2.weighty = 1.0;
        c2.weightx = 1.0;
        body.add((Component)this.statPanel, c2);
        this.itemPanel = new ItemPanel(this);
        this.itemPanel.addDataChangeListener(this);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.fill = 1;
        c3.anchor = 18;
        c3.gridx = 2;
        c3.gridy = 0;
        c3.weighty = 1.0;
        c3.weightx = 1.0;
        body.add((Component)this.itemPanel, c3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JapeFrame.this.doQuit();
            }
        });
        this.addNotify();
        this.populateActorList();
        this.pack();
        this.repaint();
    }

    private void createMenuBar() {
        this.menuBar = new MenuBar();
        this.fileMenu = new Menu("File");
        this.menuBar.add(this.fileMenu);
        this.openItem = new MenuItem("Open...");
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JapeFrame.this.doOpen();
            }
        });
        this.fileMenu.add(this.openItem);
        this.saveItem = new MenuItem("Save");
        this.saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JapeFrame.this.doSave();
            }
        });
        this.fileMenu.add(this.saveItem);
        this.saveItem.setEnabled(false);
        this.closeItem = new MenuItem("Close");
        this.closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JapeFrame.this.doClose();
            }
        });
        this.fileMenu.add(this.closeItem);
        this.closeItem.setEnabled(false);
        this.fileMenu.addSeparator();
        this.quitItem = new MenuItem("Quit");
        this.quitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JapeFrame.this.doQuit();
            }
        });
        this.fileMenu.add(this.quitItem);
        this.helpMenu = new Menu("Help");
        this.menuBar.add(this.helpMenu);
        this.menuBar.setHelpMenu(this.helpMenu);
        this.aboutItem = new MenuItem("About...");
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JapeFrame.this.doAbout();
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.setMenuBar(this.menuBar);
    }

    public boolean doAbout() {
        new JapeAbout(this).show();
        return true;
    }

    public boolean doClose() {
        if (this.saveGame != null && this.saveGameModified) {
            boolean success;
            String shortName = new File(this.saveGame.filename).getName();
            int option = OptionDialog.showConfirmDialog(this, "The file " + shortName + " has been modifed.\n" + "Do you want to save the changes?", this.getTitle(), 1, 2);
            if (option == 2 || option == -1) {
                return false;
            }
            if (option == 0 && !(success = this.doSave())) {
                return false;
            }
        }
        this.saveItem.setEnabled(false);
        this.closeItem.setEnabled(false);
        this.saveGame = null;
        this.saveGameModified = false;
        this.populateActorList();
        return true;
    }

    public boolean doOpen() {
        boolean success = this.doClose();
        if (!success) {
            return false;
        }
        FileDialog fileDialog = new FileDialog((Frame)this, "Open", 0);
        if (this.currentDir != null) {
            fileDialog.setDirectory(this.currentDir);
        }
        fileDialog.setFile("*.sav");
        fileDialog.show();
        String directory = fileDialog.getDirectory();
        String name = fileDialog.getFile();
        if (name == null) {
            return false;
        }
        this.currentDir = directory;
        String filename = new File(directory, name).toString();
        SaveGame saveGame = new SaveGame();
        try {
            saveGame.load(filename);
        }
        catch (EOFException e) {
            OptionDialog.showMessageDialog(this, "Unable to load file.\nUnexpected end of file reached.", this.getTitle(), 0);
            return false;
        }
        catch (FileNotFoundException e) {
            OptionDialog.showMessageDialog(this, "Unable to load file.\nThe system cannot find the file specified.", this.getTitle(), 0);
            return false;
        }
        catch (IOException e) {
            String errorMessage = e.getMessage();
            if (e.getMessage() == null) {
                errorMessage = "An unknown error occurred.";
            }
            OptionDialog.showMessageDialog(this, "Unable to load file.\n" + errorMessage, this.getTitle(), 0);
            return false;
        }
        catch (SaveGame.FormatException e) {
            OptionDialog.showMessageDialog(this, "Unable to load file.\nThe save game format was not recognized.\n" + e.getMessage(), this.getTitle(), 0);
            return false;
        }
        this.saveItem.setEnabled(true);
        this.closeItem.setEnabled(true);
        this.saveGame = saveGame;
        this.populateActorList();
        this.actorList.select(0);
        this.doSelectActor();
        this.saveGameModified = false;
        return true;
    }

    public boolean doSave() {
        if (this.saveGame == null) {
            return true;
        }
        try {
            this.saveGame.save();
        }
        catch (IOException e) {
            String errorMessage = e.getMessage();
            if (e.getMessage() == null) {
                errorMessage = "An unknown error occurred.";
            }
            OptionDialog.showMessageDialog(this, "Unable to save file.\n" + errorMessage, this.getTitle(), 0);
            return false;
        }
        this.saveGameModified = false;
        this.statPanel.setModified(false);
        this.itemPanel.setModified(false);
        return true;
    }

    public boolean doQuit() {
        boolean success = this.doClose();
        if (!success) {
            return false;
        }
        this.setVisible(false);
        this.dispose();
        System.exit(0);
        return true;
    }

    private boolean doSelectActor() {
        int idx = this.actorList.getSelectedIndex();
        Actor actor = null;
        Mercenary merc = null;
        if (idx != -1) {
            actor = this.saveGame.getActor(idx);
            String nickname = actor.get("Nickname");
            merc = this.saveGame.getMercByNick(nickname);
        }
        this.doSetActor(actor, merc);
        return true;
    }

    private void doSetActor(Actor actor, Mercenary merc) {
        this.currentActor = actor;
        this.currentMerc = merc;
        this.statPanel.setActor(this.currentActor, this.currentMerc);
        this.itemPanel.setActor(this.currentActor, this.currentMerc);
    }

    private void populateActorList() {
        this.actorList.removeAll();
        this.doSetActor(null, null);
        if (this.saveGame == null) {
            return;
        }
        for (int idx = 0; idx < this.saveGame.actorCount; ++idx) {
            Actor actor = this.saveGame.getActor(idx);
            String nickname = actor.get("Nickname");
            Mercenary merc = this.saveGame.getMercByNick(nickname);
            if (merc != null) {
                nickname = "*" + nickname;
            }
            this.actorList.add(nickname);
        }
    }

    public void dataChanged(DataChangeEvent event) {
        this.saveGameModified = true;
    }

    public static void main(String[] args) {
        JapeFrame japeFrame = new JapeFrame();
        japeFrame.show();
    }
}

