/*
 * Decompiled with CFR 0.152.
 */
package duggelz.jape;

import duggelz.jape.BasicStructure;
import duggelz.jape.ByteField;
import duggelz.jape.ChoiceField;
import duggelz.jape.IntField;
import duggelz.jape.JapeAlg;
import duggelz.jape.SaveGame;
import duggelz.jape.ShortField;
import duggelz.jape.Skill;
import duggelz.jape.StringField;
import java.util.Hashtable;

public class Actor
extends BasicStructure {
    public static final int NAME_OFFSET = 0;
    public static final int NAME_LENGTH = 60;
    public static final int NICK_OFFSET = 60;
    public static final int NICK_LENGTH = 20;
    public static final int MED_OFFSET = 261;
    public static final int STR_OFFSET = 296;
    public static final int MAX_HEALTH_OFFSET = 297;
    public static final int LVL_INC_OFFSET = 298;
    public static final int HEALTH_INC_OFFSET = 299;
    public static final int AGI_INC_OFFSET = 300;
    public static final int DEX_INC_OFFSET = 301;
    public static final int WIS_INC_OFFSET = 302;
    public static final int MRK_INC_OFFSET = 303;
    public static final int MED_INC_OFFSET = 304;
    public static final int MEC_INC_OFFSET = 305;
    public static final int EXP_INC_OFFSET = 306;
    public static final int STR_INC_OFFSET = 307;
    public static final int LDR_INC_OFFSET = 308;
    public static final int KILLS_OFFSET = 310;
    public static final int KILLS_LENGTH = 2;
    public static final int ASSISTS_OFFSET = 312;
    public static final int ASSISTS_LENGTH = 2;
    public static final int SHOTS_FIRED_OFFSET = 314;
    public static final int SHOTS_FIRED_LENGTH = 2;
    public static final int SHOTS_HIT_OFFSET = 316;
    public static final int SHOTS_HIT_LENGTH = 2;
    public static final int BATTLES_OFFSET = 318;
    public static final int BATTLES_LENGTH = 2;
    public static final int WOUNDS_OFFSET = 320;
    public static final int WOUNDS_LENGTH = 2;
    public static final int HEALTH_OFFSET = 334;
    public static final int DEX_OFFSET = 335;
    public static final int PERSONALITY_OFFSET = 336;
    public static final int SKILL1_OFFSET = 337;
    public static final int EXP_OFFSET = 339;
    public static final int SKILL2_OFFSET = 340;
    public static final int LDR_OFFSET = 341;
    public static final int LVL_OFFSET = 352;
    public static final int MRK_OFFSET = 353;
    public static final int WIS_OFFSET = 355;
    public static final int AGI_OFFSET_99 = 405;
    public static final int AGI_OFFSET_103 = 367;
    public static final int MEC_OFFSET_99 = 411;
    public static final int MEC_OFFSET_103 = 373;
    public static final int CHECKSUM_OFFSET_99 = 696;
    public static final int CHECKSUM_OFFSET_103 = 616;
    public static final int CHECKSUM_LENGTH = 4;
    public int savedGameVersion;
    public int AGI_OFFSET;
    public int MEC_OFFSET;
    public int CHECKSUM_OFFSET;

    public Actor(byte[] rawData, int savedGameVersion, int[] table) {
        super(new Hashtable());
        this.savedGameVersion = savedGameVersion;
        this.decode(rawData, table);
        if (savedGameVersion <= 99) {
            this.AGI_OFFSET = 405;
            this.MEC_OFFSET = 411;
            this.CHECKSUM_OFFSET = 696;
        } else {
            this.AGI_OFFSET = 367;
            this.MEC_OFFSET = 373;
            this.CHECKSUM_OFFSET = 616;
        }
        this.fields.put("Name", new StringField(0, 60));
        this.fields.put("Nickname", new StringField(60, 20));
        this.fields.put("Medical", new ByteField(261));
        this.fields.put("Strength", new ByteField(296));
        this.fields.put("Max Health", new ByteField(297));
        this.fields.put("Level Inc", new ByteField(298));
        this.fields.put("Health Inc", new ByteField(299));
        this.fields.put("Agility Inc", new ByteField(300));
        this.fields.put("Dexterity Inc", new ByteField(301));
        this.fields.put("Wisdom Inc", new ByteField(302));
        this.fields.put("Marksmanship Inc", new ByteField(303));
        this.fields.put("Medical Inc", new ByteField(304));
        this.fields.put("Mechanical Inc", new ByteField(305));
        this.fields.put("Explosives Inc", new ByteField(306));
        this.fields.put("Strength Inc", new ByteField(307));
        this.fields.put("Leadership Inc", new ByteField(308));
        this.fields.put("Kills", new ShortField(310));
        this.fields.put("Assists", new ShortField(312));
        this.fields.put("Shots Fired", new ShortField(314));
        this.fields.put("Shots Hit", new ShortField(316));
        this.fields.put("Battles", new ShortField(318));
        this.fields.put("Wounds", new ShortField(320));
        this.fields.put("Health", new ByteField(334));
        this.fields.put("Dexterity", new ByteField(335));
        this.fields.put("Personality", new ByteField(336));
        this.fields.put("Skill1", new ChoiceField(new ByteField(337), Skill.table));
        this.fields.put("Explosives", new ByteField(339));
        this.fields.put("Skill2", new ChoiceField(new ByteField(340), Skill.table));
        this.fields.put("Leadership", new ByteField(341));
        this.fields.put("Level", new ByteField(352));
        this.fields.put("Marksmanship", new ByteField(353));
        this.fields.put("Wisdom", new ByteField(355));
        this.fields.put("Agility", new ByteField(this.AGI_OFFSET));
        this.fields.put("Mechanical", new ByteField(this.MEC_OFFSET));
        this.fields.put("Checksum", new IntField(this.CHECKSUM_OFFSET));
    }

    public void decode(byte[] ciphertext, int[] table) {
        if (this.savedGameVersion <= 99) {
            this.data = JapeAlg.Decode(ciphertext, ciphertext.length, table);
        } else {
            this.data = new byte[ciphertext.length];
            System.arraycopy(ciphertext, 0, this.data, 0, ciphertext.length);
        }
    }

    public byte[] encode(int[] table) {
        byte[] ciphertext;
        this.recomputeChecksum();
        if (this.savedGameVersion <= 99) {
            ciphertext = JapeAlg.Encode(this.data, this.data.length, table);
        } else {
            ciphertext = new byte[this.data.length];
            System.arraycopy(this.data, 0, ciphertext, 0, this.data.length);
        }
        return ciphertext;
    }

    public int computeChecksum() {
        if (this.savedGameVersion <= 99) {
            return JapeAlg.ActorChecksum(this.data);
        }
        int checksum = 1;
        checksum += this.getInt("Health") + 1;
        checksum *= this.getInt("Max Health") + 1;
        checksum += this.getInt("Agility") + 1;
        checksum *= this.getInt("Dexterity") + 1;
        checksum += this.getInt("Strength") + 1;
        checksum *= this.getInt("Marksmanship") + 1;
        checksum += this.getInt("Medical") + 1;
        checksum *= this.getInt("Mechanical") + 1;
        checksum += this.getInt("Explosives") + 1;
        checksum *= this.getInt("Level") + 1;
        int invBaseOffset = 632;
        IntField invsize = new IntField(invBaseOffset);
        int inventorySize = invsize.getInt(this.data);
        for (int itemIdx = 0; itemIdx < inventorySize; ++itemIdx) {
            int offset = invBaseOffset + 4 + itemIdx * 12;
            IntField inv = new IntField(offset);
            checksum += inv.getInt(this.data);
            IntField bInvNumber = new IntField(offset + 8);
            checksum += bInvNumber.getInt(this.data);
        }
        return checksum;
    }

    public void validateChecksum() throws SaveGame.FormatException {
        int savedChecksum;
        int checksum = this.computeChecksum();
        if (checksum != (savedChecksum = this.getInt("Checksum"))) {
            throw new SaveGame.FormatException("Invalid checksum (0x" + Integer.toHexString(checksum) + " vs 0x" + Integer.toHexString(savedChecksum) + ") in MERCPROFILESTRUCT for '" + this.get("Name") + "'");
        }
    }

    public void recomputeChecksum() {
        int checksum = this.computeChecksum();
        this.setInt("Checksum", checksum);
    }
}

