/*
 * Decompiled with CFR 0.152.
 */
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class TextView
extends TextField
implements FieldView,
TextListener {
    private boolean suppressEvents = false;
    private String fieldName;
    private int length;
    private boolean modified = false;
    private String oldValue;
    private Structure struct;
    private DataChangeMixin mixin = new DataChangeMixin();
    static final long serialVersionUID = 12469L;

    public TextView(String string, int n) {
        super(n);
        this.fieldName = string;
        this.length = n;
        this.addTextListener(this);
    }

    public void addDataChangeListener(DataChangeListener dataChangeListener) {
        this.mixin.addDataChangeListener(dataChangeListener);
    }

    public void commit(String string) {
        String string2;
        if (this.struct != null && ((string2 = this.struct.get(this.fieldName)) == null && string != null || string2 != null && !string2.equals(string))) {
            this.modified = true;
            this.struct.set(this.fieldName, string);
            this.fireDataChangeEvent(new DataChangeEvent(this, this.oldValue, string));
        }
    }

    public void fireDataChangeEvent(DataChangeEvent dataChangeEvent) {
        this.mixin.fireDataChangeEvent(dataChangeEvent);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getValue() {
        return this.getText();
    }

    public boolean isModified() {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        try {
            this.suppressEvents = true;
            String string = null;
            if (this.struct != null) {
                string = this.struct.get(this.fieldName);
            }
            if (string != null) {
                this.setText(string);
            } else {
                this.setText("");
            }
            this.oldValue = string;
            this.modified = false;
        }
        finally {
            this.suppressEvents = false;
        }
    }

    public void removeDataChangeListener(DataChangeListener dataChangeListener) {
        this.mixin.removeDataChangeListener(dataChangeListener);
    }

    public void setStruct(Structure structure) {
        this.struct = structure;
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.suppressEvents) {
            return;
        }
        String string = this.getText();
        if (string.length() <= this.length) {
            this.commit(string);
            this.oldValue = string;
        } else {
            this.setText(this.oldValue);
        }
    }
}

