/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Vector;

public class StatPanel
extends InsetPanel
implements DataChangeListener {
    public static final long serialVersionUID = 12469L;
    private Frame parent;
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraint = new GridBagConstraints();
    private boolean modified = false;
    private Actor actor;
    private Mercenary merc;
    private Vector views = new Vector();
    private DataChangeMixin mixin = new DataChangeMixin();

    public StatPanel(Frame frame) {
        super(new Insets(10, 10, 10, 10));
        this.parent = frame;
        this.setLayout(this.layout);
        this.constraint.anchor = 16;
        this.constraint.fill = 0;
        this.constraint.gridx = 0;
        this.constraint.gridheight = 1;
        this.constraint.gridwidth = 1;
        this.constraint.insets = new Insets(0, 0, 0, 0);
        this.addStringStat("Name", "Name", 30);
        this.addStringStat("Nickname", "Nickname", 30);
        this.newRow();
        this.addText(1, "Gesundheit", 0);
        this.addNumberView(1, "Health", 3);
        this.addText(1, "/", 1);
        this.addNumberView(1, "Max Health", 3);
        this.addText(1, "(+", 2);
        this.addNumberView(1, "Health Inc", 3);
        this.addText(1, ")", 0);
        this.addByteStat("Energie", "Energy");
        this.addByteStat("Moral", "Morale");
        this.addIncStat("Beweglichkeit", "Agility", "Agility Inc");
        this.addIncStat("Geschicklichkeit", "Dexterity", "Dexterity Inc");
        this.addIncStat("Kraft", "Strength", "Strength Inc");
        this.addIncStat("F\u00fchrungsqualit\u00e4t", "Leadership", "Leadership Inc");
        this.addIncStat("Weisheit", "Wisdom", "Wisdom Inc");
        this.addIncStat("Treffsicherheit", "Marksmanship", "Marksmanship Inc");
        this.addIncStat("Sprengstoffe", "Explosives", "Explosives Inc");
        this.addIncStat("Mechanik", "Mechanical", "Mechanical Inc");
        this.addIncStat("Medizin", "Medical", "Medical Inc");
        this.addIncStat("Erfahrungslevel", "Level", "Level Inc");
        this.addChoiceStat("F\u00e4higkeit 1", "Skill1", Skill.list);
        this.addChoiceStat("F\u00e4higkeit 2", "Skill2", Skill.list);
        this.addShortStat("T\u00f6tete", "Kills");
        this.addShortStat("Half bei", "Assists");
        this.addShortStat("Feuerte Sch\u00fcsse ab", "Shots Fired");
        this.addShortStat("Sch\u00fcsse getroffen", "Shots Hit");
        this.addShortStat("Eins\u00e4tze", "Battles");
        this.addShortStat("Verwundet", "Wounds");
        this.newRow();
        this.constraint.fill = 1;
        this.constraint.weightx = 1.0;
        this.constraint.weighty = 1.0;
        this.addComponent(0, new Label());
    }

    public void addByteStat(String string, String string2) {
        this.newRow();
        this.addText(1, string, 0);
        this.addNumberView(1, string2, 3);
    }

    public void addChoiceStat(String string, String string2, Vector vector) {
        this.newRow();
        this.addText(1, string, 0);
        ChoiceView choiceView = new ChoiceView(string2, vector);
        this.addComponent(0, choiceView);
        this.views.addElement(choiceView);
        choiceView.addDataChangeListener(this);
    }

    private void addComponent(int n, Component component) {
        this.constraint.gridwidth = n;
        this.add(component, this.constraint);
        this.constraint.gridx += n;
    }

    public void addDataChangeListener(DataChangeListener dataChangeListener) {
        this.mixin.addDataChangeListener(dataChangeListener);
    }

    public void addIncStat(String string, String string2, String string3) {
        this.newRow();
        this.addText(1, string, 0);
        this.addNumberView(1, string2, 3);
        this.addText(1, "(+", 2);
        this.addNumberView(1, string3, 3);
        this.addText(1, ")", 0);
    }

    private void addNumberView(int n, String string, int n2) {
        NumberView numberView = new NumberView(string, n2);
        this.addComponent(n, numberView);
        this.views.addElement(numberView);
        numberView.addDataChangeListener(this);
    }

    public void addShortStat(String string, String string2) {
        this.addByteStat(string, string2);
    }

    public void addStringStat(String string, String string2, int n) {
        this.newRow();
        this.addText(1, string, 0);
        this.addNumberView(0, string2, n);
    }

    private void addText(int n, String string, int n2) {
        Label label = new Label(string, n2);
        this.addComponent(n, label);
    }

    private void addTextView(int n, String string, int n2) {
        TextView textView = new TextView(string, n2);
        this.addComponent(n, textView);
        this.views.addElement(textView);
        textView.addDataChangeListener(this);
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        FieldView fieldView = (FieldView)dataChangeEvent.getSource();
        String string = dataChangeEvent.getOldValue();
        String string2 = dataChangeEvent.getNewValue();
        if (this.actor == null) {
            return;
        }
        this.modified = true;
        this.fireDataChangeEvent(dataChangeEvent);
    }

    public void fireDataChangeEvent(DataChangeEvent dataChangeEvent) {
        this.mixin.fireDataChangeEvent(dataChangeEvent);
    }

    public boolean isModified() {
        return this.modified;
    }

    private void newRow() {
        ++this.constraint.gridy;
        this.constraint.gridx = 0;
    }

    public void removeDataChangeListener(DataChangeListener dataChangeListener) {
        this.mixin.removeDataChangeListener(dataChangeListener);
    }

    public void setActor(Actor actor, Mercenary mercenary) {
        BasicStructure basicStructure;
        this.actor = actor;
        this.merc = mercenary;
        if (this.merc != null) {
            basicStructure = this.merc;
            basicStructure.chain(this.actor);
        } else {
            basicStructure = this.actor;
        }
        Enumeration enumeration = this.views.elements();
        while (enumeration.hasMoreElements()) {
            FieldView fieldView = (FieldView)enumeration.nextElement();
            fieldView.setStruct(basicStructure);
            fieldView.refresh();
        }
        this.modified = false;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }
}

