/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SaveGame {
    public int thingCountOffset = 815;
    public int thingCount = 0;
    public int thingOffset = 819;
    public int thingDataLength = 28;
    public int otherThingDataLength = 7440;
    public int actorCount = 170;
    public int actorDataLength = 716;
    public int actorOffset = 0;
    public Actor[] actors = new Actor[this.actorCount];
    public int mercCount = 0;
    public int mercMaxCount = 18;
    public int mercDataLength = 2462;
    public int mercOffset = 0;
    public Mercenary[] mercs = new Mercenary[this.mercMaxCount];
    public String filename;
    public RandomAccessFile file;
    public int codeTableIdx;
    public int codeTableSubIdx;
    public int[] codeTable;
    public static final int MAXLENGTH = 16384;
    public static final long serialVersionUID = 12469L;

    public int[] findActorCodeTable(byte[] byArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 57; ++j) {
                byte[] byArray2 = JapeAlg.Decode(byArray, 8, JapeConst.CodeTables[i][j]);
                if (byArray2[1] != 0 || byArray2[3] != 0 || byArray2[5] != 0 || byArray2[7] != 0) continue;
                int[] nArray = new int[]{i, j};
                return nArray;
            }
        }
        return null;
    }

    public Actor getActor(int n) {
        return this.actors[n];
    }

    public Actor getActorByNick(String string) {
        for (int i = 0; i < this.actorCount; ++i) {
            Actor actor = this.actors[i];
            if (actor == null || !actor.get("Nickname").equals(string)) continue;
            return actor;
        }
        return null;
    }

    public Mercenary getMerc(int n) {
        return this.mercs[n];
    }

    public Mercenary getMercByNick(String string) {
        for (int i = 0; i < this.mercCount; ++i) {
            Mercenary mercenary = this.mercs[i];
            if (mercenary == null || !mercenary.get("Nickname").equals(string)) continue;
            return mercenary;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) throws IOException, FormatException {
        this.filename = string;
        this.file = new RandomAccessFile(this.filename, "r");
        try {
            this.file.seek(this.thingCountOffset);
            this.thingCount = this.file.readByte() & 0xFF;
            this.actorOffset = this.thingOffset + this.thingCount * this.thingDataLength + this.otherThingDataLength;
            this.mercOffset = this.actorOffset + this.actorDataLength * this.actorCount;
            this.file.seek(this.actorOffset);
            byte[] byArray = new byte[16];
            this.file.readFully(byArray);
            int[] nArray = this.findActorCodeTable(byArray);
            if (nArray == null) {
                throw new FormatException();
            }
            this.codeTableIdx = nArray[0];
            this.codeTableSubIdx = nArray[1];
            this.codeTable = JapeConst.CodeTables[this.codeTableIdx][this.codeTableSubIdx];
            this.loadActors();
            this.loadMercs();
        }
        finally {
            this.file.close();
        }
    }

    public void loadActors() throws IOException {
        this.file.seek(this.actorOffset);
        for (int i = 0; i < this.actorCount; ++i) {
            Actor actor;
            byte[] byArray = new byte[this.actorDataLength];
            this.file.readFully(byArray);
            this.actors[i] = actor = new Actor(byArray, this.codeTable);
        }
    }

    public void loadMercs() throws IOException {
        this.file.seek(this.mercOffset);
        for (int i = 0; i < 18; ++i) {
            Mercenary mercenary;
            int n;
            for (n = 0; n < 16; ++n) {
                if (this.file.readByte() != 1) continue;
                this.file.seek(this.file.getFilePointer() - 1L);
                break;
            }
            if (n == 16) break;
            byte[] byArray = new byte[this.mercDataLength];
            this.file.readFully(byArray);
            this.mercs[this.mercCount] = mercenary = new Mercenary(byArray, this.codeTable);
            ++this.mercCount;
            mercenary.adjustCount = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.filename);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        byte[] byArray = new byte[16384];
        int n = 1;
        while (n > 0) {
            n = fileInputStream.read(byArray, 0, 16384);
            if (n <= 0) continue;
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
        this.file = new RandomAccessFile(string, "rw");
        try {
            this.saveActors();
            this.saveMercs();
        }
        finally {
            this.file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        this.file = new RandomAccessFile(this.filename, "rw");
        try {
            this.saveActors();
            this.saveMercs();
        }
        finally {
            this.file.close();
        }
    }

    public void saveActors() throws IOException {
        this.file.seek(this.actorOffset);
        for (int i = 0; i < this.actorCount; ++i) {
            Actor actor = this.actors[i];
            byte[] byArray = actor.encode(this.codeTable);
            this.file.write(byArray);
        }
    }

    public void saveMercs() throws IOException {
        this.file.seek(this.mercOffset);
        for (int i = 0; i < this.mercCount; ++i) {
            Mercenary mercenary = this.mercs[i];
            byte[] byArray = mercenary.encode(this.codeTable);
            for (int j = 0; j < mercenary.adjustCount; ++j) {
                this.file.writeByte(0);
            }
            this.file.write(byArray);
        }
    }

    public class FormatException
    extends Exception {
        public static final long serialVersionUID = 6384236L;
    }
}

