/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;

public class Mercenary
extends BasicStructure {
    public static final int CIPHERTEXT_OFFSET = 1;
    public static final int CIPHERTEXT_LENGTH = 2328;
    public static final int FIRST_ITEM_OFFSET = 12;
    public static final int ITEM_LENGTH = 36;
    public static final int ITEM_COUNT = 19;
    public static final int HELMET_INDEX = 0;
    public static final int BODY_ARMOR_INDEX = 1;
    public static final int LEG_ARMOR_INDEX = 2;
    public static final int HEADGEAR_1_INDEX = 3;
    public static final int HEADGEAR_2_INDEX = 4;
    public static final int RIGHT_HAND_INDEX = 5;
    public static final int LEFT_HAND_INDEX = 6;
    public static final int BACKPACK_1_3_INDEX = 7;
    public static final int BACKPACK_2_3_INDEX = 8;
    public static final int BACKPACK_3_3_INDEX = 9;
    public static final int BACKPACK_4_3_INDEX = 10;
    public static final int BACKPACK_1_1_INDEX = 11;
    public static final int BACKPACK_2_1_INDEX = 12;
    public static final int BACKPACK_3_1_INDEX = 13;
    public static final int BACKPACK_4_1_INDEX = 14;
    public static final int BACKPACK_1_2_INDEX = 15;
    public static final int BACKPACK_2_2_INDEX = 16;
    public static final int BACKPACK_3_2_INDEX = 17;
    public static final int BACKPACK_4_2_INDEX = 18;
    public static final int ENERGY_OFFSET = 711;
    public static final int MAX_ENERGY_OFFSET = 712;
    public static final int NICK_OFFSET = 730;
    public static final int NICK_LENGTH = 20;
    public static final int SKILL1_OFFSET = 832;
    public static final int SKILL2_OFFSET = 833;
    public static final int DEX_OFFSET = 840;
    public static final int WIS_OFFSET = 841;
    public static final int LVL_OFFSET = 849;
    public static final int HEALTH_OFFSET = 868;
    public static final int AGI_OFFSET = 880;
    public static final int STR_OFFSET = 886;
    public static final int LDR_OFFSET = 895;
    public static final int MEC_OFFSET = 916;
    public static final int MAX_HEALTH_OFFSET = 917;
    public static final int HEAD_OFFSET = 924;
    public static final int PANTS_OFFSET = 954;
    public static final int VEST_OFFSET = 984;
    public static final int SKIN_OFFSET = 1014;
    public static final int MED_OFFSET = 1372;
    public static final int MRK_OFFSET = 1377;
    public static final int EXP_OFFSET = 1378;
    public static final int MORALE_OFFSET = 1736;
    public static final int CHECKSUM_OFFSET = 2208;
    public static final int CHECKSUM_LENGTH = 4;
    public static Hashtable classFields = new Hashtable();
    public byte[] allData;
    public Item[] items = new Item[19];
    public int adjustCount;

    public Mercenary(byte[] byArray, int[] nArray) {
        super(classFields);
        this.decode(byArray, nArray);
    }

    public void decode(byte[] byArray, int[] nArray) {
        this.allData = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.allData, 0, this.allData.length);
        byte[] byArray2 = new byte[2328];
        System.arraycopy(byArray, 1, byArray2, 0, 2328);
        byte[] byArray3 = JapeAlg.Decode(byArray2, byArray2.length, nArray);
        this.data = byArray3;
        for (int i = 0; i < 19; ++i) {
            Item item;
            byte[] byArray4 = new byte[36];
            int n = 12 + i * 36;
            System.arraycopy(this.data, n, byArray4, 0, 36);
            this.items[i] = item = new Item(byArray4);
        }
    }

    public byte[] encode(int[] nArray) {
        byte[] byArray;
        Object object;
        for (int i = 0; i < 19; ++i) {
            object = this.items[i];
            byArray = ((Item)object).encode();
            int n = 12 + i * 36;
            System.arraycopy(byArray, 0, this.data, n, 36);
        }
        this.recomputeChecksum();
        byte[] byArray2 = new byte[this.allData.length];
        System.arraycopy(this.allData, 0, byArray2, 0, this.allData.length);
        object = new byte[2328];
        System.arraycopy(this.data, 0, object, 0, 2328);
        byArray = JapeAlg.Encode((byte[])object, ((Object)object).length, nArray);
        System.arraycopy(byArray, 0, byArray2, 1, 2328);
        return byArray2;
    }

    public void recomputeChecksum() {
        int n = JapeAlg.MercChecksum(this.data);
        this.data[2208] = (byte)(n & 0xFF);
        this.data[2209] = (byte)(n >> 8 & 0xFF);
        this.data[2210] = (byte)(n >> 16 & 0xFF);
        this.data[2211] = (byte)(n >> 24 & 0xFF);
    }

    static {
        classFields.put("Energy", new ByteField(711));
        classFields.put("Max Energy", new ByteField(712));
        classFields.put("Nickname", new StringField(730, 20));
        classFields.put("Skill1", new ChoiceField(new ByteField(832), Skill.table));
        classFields.put("Skill2", new ChoiceField(new ByteField(833), Skill.table));
        classFields.put("Dexterity", new ByteField(840));
        classFields.put("Wisdom", new ByteField(841));
        classFields.put("Level", new ByteField(849));
        classFields.put("Health", new ByteField(868));
        classFields.put("Agility", new ByteField(880));
        classFields.put("Strength", new ByteField(886));
        classFields.put("Leadership", new ByteField(895));
        classFields.put("Mechanical", new ByteField(916));
        classFields.put("Max Health", new ByteField(917));
        classFields.put("Head", new ByteField(924));
        classFields.put("Pants", new ByteField(954));
        classFields.put("Vest", new ByteField(984));
        classFields.put("Skin", new ByteField(1014));
        classFields.put("Medical", new ByteField(1372));
        classFields.put("Marksmanship", new ByteField(1377));
        classFields.put("Explosives", new ByteField(1378));
        classFields.put("Morale", new ByteField(1736));
        classFields.put("Checksum", new IntField(2208));
    }
}

