/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class JapeFrame
extends Frame
implements DataChangeListener {
    private static final int DEFAULT_WIDTH = 450;
    private static final int DEFAULT_HEIGHT = 450;
    public static final long serialVersionUID = 6384346L;
    private GridBagLayout layout;
    private List actorList;
    private StatPanel statPanel;
    private ItemPanel itemPanel;
    private MenuBar menuBar;
    private Menu fileMenu;
    private Menu bearbeitenMenu;
    private MenuItem openItem;
    private MenuItem saveItem;
    private MenuItem saveasItem;
    private MenuItem closeItem;
    private MenuItem quitItem;
    private MenuItem openAgainItem;
    private MenuItem sortbyMercItem;
    private MenuItem nosortItem;
    private Menu helpMenu;
    private MenuItem aboutItem;
    private SaveGame saveGame;
    private boolean saveGameModified;
    private Actor currentActor;
    private Mercenary currentMerc;
    private String currentDir;
    private static Frame feld;
    private String suche;
    private String vergleich;

    public JapeFrame() {
        super("JAPE - Jagged Alliance 2 Savegame Editor");
        feld = this;
        Color color = new Color(SystemColor.menu.getRGB());
        ((Component)this).setBackground(color);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.suche = new String();
        this.suche = "";
        this.vergleich = new String();
        this.vergleich = "";
        this.layout = new GridBagLayout();
        this.currentDir = System.getProperty("user.dir");
        this.createMenuBar();
        Panel panel = new Panel();
        panel.setLayout(this.layout);
        this.add("Center", panel);
        this.actorList = new List();
        this.actorList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JapeFrame.this.doSelectActor();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        panel.add((Component)this.actorList, gridBagConstraints);
        this.statPanel = new StatPanel(this);
        this.statPanel.addDataChangeListener(this);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        panel.add((Component)this.statPanel, gridBagConstraints2);
        this.itemPanel = new ItemPanel(this);
        this.itemPanel.addDataChangeListener(this);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.weightx = 1.0;
        panel.add((Component)this.itemPanel, gridBagConstraints3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JapeFrame.this.doQuit();
            }
        });
        this.addNotify();
        this.populateActorList();
        this.pack();
        this.repaint();
    }

    private void createMenuBar() {
        this.menuBar = new MenuBar();
        this.fileMenu = new Menu("Datei");
        this.menuBar.add(this.fileMenu);
        this.openItem = new MenuItem("Laden..");
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JapeFrame.this.doOpen();
            }
        });
        this.fileMenu.add(this.openItem);
        this.openAgainItem = new MenuItem("Erneut \u00d6ffnen");
        this.openAgainItem.setEnabled(false);
        this.openAgainItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((JapeFrame)JapeFrame.this).saveGame.filename != null) {
                    JapeFrame.this.OpenGame(((JapeFrame)JapeFrame.this).saveGame.filename);
                }
            }
        });
        this.fileMenu.add(this.openAgainItem);
        this.saveItem = new MenuItem("Speichern");
        this.saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JapeFrame.this.doSave();
            }
        });
        this.fileMenu.add(this.saveItem);
        this.saveItem.setEnabled(false);
        this.saveasItem = new MenuItem("Speichern unter");
        this.saveasItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JapeFrame.this.doSaveas();
            }
        });
        this.fileMenu.add(this.saveasItem);
        this.saveasItem.setEnabled(false);
        this.closeItem = new MenuItem("Schlie\u00dfen");
        this.closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JapeFrame.this.doClose();
            }
        });
        this.fileMenu.add(this.closeItem);
        this.closeItem.setEnabled(false);
        this.fileMenu.addSeparator();
        this.quitItem = new MenuItem("Beenden");
        this.quitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JapeFrame.this.doQuit();
            }
        });
        this.fileMenu.add(this.quitItem);
        this.bearbeitenMenu = new Menu("Bearbeiten");
        this.bearbeitenMenu.setEnabled(false);
        this.menuBar.add(this.bearbeitenMenu);
        this.helpMenu = new Menu("Hilfe");
        this.nosortItem = new MenuItem("RPC unsortiert");
        this.bearbeitenMenu.add(this.nosortItem);
        this.bearbeitenMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JapeFrame.this.doNoSort();
            }
        });
        this.sortbyMercItem = new MenuItem("RPC sortiert");
        this.sortbyMercItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JapeFrame.this.doSort();
            }
        });
        this.bearbeitenMenu.add(this.sortbyMercItem);
        this.menuBar.add(this.helpMenu);
        this.menuBar.setHelpMenu(this.helpMenu);
        this.aboutItem = new MenuItem("\u00dcber...");
        this.helpMenu.add(this.aboutItem);
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "JAPE: A Jagged Alliance 2 Save Game Editor\nVersion 0.34\nCopyright (c) 1999  Douglas Greiman\nDeutsche Portierung (c) 2005 von Bernd Leitenberger\n";
                JOptionPane.showMessageDialog(null, string, "Info \u00fcber Jape", 1);
            }
        });
        this.setMenuBar(this.menuBar);
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        this.saveGameModified = true;
    }

    public boolean doClose() {
        if (this.saveGame != null && this.saveGameModified) {
            boolean bl;
            String string = new File(this.saveGame.filename).getName();
            int n = JOptionPane.showConfirmDialog(this, "Die Datei " + string + " wurde ver\u00e4ndert.\n" + "Wollen Sie die \u00c4nderungen speichern ?", this.getTitle(), 1, 3);
            if (n == 2) {
                return false;
            }
            if (n == 0 && !(bl = this.doSave())) {
                return false;
            }
        }
        this.saveItem.setEnabled(false);
        this.saveasItem.setEnabled(false);
        this.closeItem.setEnabled(false);
        this.openAgainItem.setEnabled(false);
        this.bearbeitenMenu.setEnabled(false);
        this.saveGame = null;
        this.saveGameModified = false;
        this.populateActorList();
        return true;
    }

    private boolean OpenGame(String string) {
        SaveGame saveGame = new SaveGame();
        try {
            saveGame.load(string);
        }
        catch (EOFException eOFException) {
            JOptionPane.showMessageDialog(this, "Kann Datei nicht laden.\nUnerwartet Dateiende erreicht.", this.getTitle(), 0);
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Kann Datei nicht laden.\nDatei kann nicht gefunden oder geladen werden", this.getTitle(), 0);
            return false;
        }
        catch (IOException iOException) {
            String string2 = iOException.getMessage();
            if (iOException.getMessage() == null) {
                string2 = "Ein nicht genau spezifizierter Fehler trat auf.";
            }
            JOptionPane.showMessageDialog(this, "Kann Datei nicht laden.\n" + string2, this.getTitle(), 0);
            return false;
        }
        catch (SaveGame.FormatException formatException) {
            JOptionPane.showMessageDialog(this, "Kann Datei nicht laden.\nDas Spielformat ist unbekannt.", this.getTitle(), 0);
            return false;
        }
        this.saveItem.setEnabled(true);
        this.saveasItem.setEnabled(true);
        this.bearbeitenMenu.setEnabled(true);
        this.closeItem.setEnabled(true);
        this.openAgainItem.setEnabled(true);
        this.saveGame = saveGame;
        this.populateActorList();
        this.actorList.select(0);
        this.doSelectActor();
        this.saveGameModified = false;
        return true;
    }

    public boolean doSaveas() {
        String string = this.saveGame.filename;
        FileDialog fileDialog = new FileDialog((Frame)this, "Speichern unter", 0);
        fileDialog.setMode(1);
        if (this.currentDir != null) {
            fileDialog.setDirectory(this.currentDir);
        }
        fileDialog.setFile(string);
        fileDialog.show();
        String string2 = fileDialog.getDirectory();
        string = fileDialog.getFile();
        if (string == null) {
            return false;
        }
        this.currentDir = string2;
        string = new File(string2, string).toString();
        if (this.saveGame == null) {
            return true;
        }
        try {
            this.saveGame.saveAs(string);
        }
        catch (IOException iOException) {
            String string3 = iOException.getMessage();
            if (iOException.getMessage() == null) {
                string3 = "Ein nicht genau spezifizierter Fehler trat auf.";
            }
            JOptionPane.showMessageDialog(this, "Kann die Datei nicht speichern.\n" + string3, this.getTitle(), 0);
            return false;
        }
        this.saveGameModified = false;
        this.statPanel.setModified(false);
        this.itemPanel.setModified(false);
        return true;
    }

    public boolean doSort() {
        int n;
        this.actorList.removeAll();
        this.doSetActor(null, null);
        if (this.saveGame == null) {
            return false;
        }
        String[] stringArray = new String[this.saveGame.actorCount];
        for (int i = 0; i < this.saveGame.actorCount; ++i) {
            Actor actor = this.saveGame.getActor(i);
            String string = actor.get("Nickname");
            Mercenary mercenary = this.saveGame.getMercByNick(string);
            if (mercenary != null) {
                string = "*" + string;
            }
            stringArray[i] = new String(string);
        }
        String string = new String();
        for (n = 0; n < stringArray.length - 1; ++n) {
            for (int i = n + 1; i < stringArray.length; ++i) {
                if (stringArray[n].compareToIgnoreCase(stringArray[i]) <= 0) continue;
                string = stringArray[n];
                stringArray[n] = stringArray[i];
                stringArray[i] = string;
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.actorList.add(stringArray[n]);
        }
        return true;
    }

    public boolean doNoSort() {
        this.actorList.removeAll();
        this.doSetActor(null, null);
        if (this.saveGame == null) {
            return false;
        }
        String[] stringArray = new String[this.saveGame.actorCount];
        for (int i = 0; i < this.saveGame.actorCount; ++i) {
            Actor actor = this.saveGame.getActor(i);
            String string = actor.get("Nickname");
            Mercenary mercenary = this.saveGame.getMercByNick(string);
            if (mercenary != null) {
                string = "*" + string;
            }
            this.actorList.add(string);
        }
        return true;
    }

    public boolean doOpen() {
        boolean bl = this.doClose();
        if (!bl) {
            return false;
        }
        FileDialog fileDialog = new FileDialog((Frame)this, "\u00d6ffnen", 0);
        if (this.currentDir != null) {
            fileDialog.setDirectory(this.currentDir);
        }
        fileDialog.setFile("*.sav");
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            return false;
        }
        this.currentDir = string;
        String string3 = new File(string, string2).toString();
        this.OpenGame(string3);
        return true;
    }

    public boolean doQuit() {
        boolean bl = this.doClose();
        if (!bl) {
            return false;
        }
        ((Component)this).setVisible(false);
        this.dispose();
        System.exit(0);
        return true;
    }

    public boolean doSave() {
        if (this.saveGame == null) {
            return true;
        }
        try {
            this.saveGame.save();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (iOException.getMessage() == null) {
                string = "Ein nicht genau spezifizierter Fehler trat auf.";
            }
            JOptionPane.showMessageDialog(this, "Kann die Datei nicht speichern.\n" + string, this.getTitle(), 0);
            return false;
        }
        this.saveGameModified = false;
        this.statPanel.setModified(false);
        this.itemPanel.setModified(false);
        return true;
    }

    private boolean doSelectActor() {
        int n = this.actorList.getSelectedIndex();
        String string = this.actorList.getItem(n);
        if (string.length() > 0 && string.startsWith("*")) {
            string = string.substring(1, string.length());
        }
        Actor actor = null;
        Mercenary mercenary = null;
        if (n != -1) {
            actor = this.saveGame.getActorByNick(string);
            String string2 = string;
            mercenary = this.saveGame.getMercByNick(string2);
        }
        this.doSetActor(actor, mercenary);
        return true;
    }

    private void doSetActor(Actor actor, Mercenary mercenary) {
        this.currentActor = actor;
        this.currentMerc = mercenary;
        this.statPanel.setActor(this.currentActor, this.currentMerc);
        this.itemPanel.setActor(this.currentActor, this.currentMerc);
    }

    public static void main(String[] stringArray) {
        JapeFrame japeFrame = new JapeFrame();
        japeFrame.show();
    }

    private void populateActorList() {
        int n;
        this.actorList.removeAll();
        this.doSetActor(null, null);
        if (this.saveGame == null) {
            return;
        }
        String[] stringArray = new String[this.saveGame.actorCount];
        for (int i = 0; i < this.saveGame.actorCount; ++i) {
            Actor actor = this.saveGame.getActor(i);
            String string = actor.get("Nickname");
            Mercenary mercenary = this.saveGame.getMercByNick(string);
            if (mercenary != null) {
                string = "*" + string;
            }
            stringArray[i] = new String(string);
        }
        String string = new String();
        for (n = 0; n < stringArray.length - 1; ++n) {
            for (int i = n + 1; i < stringArray.length; ++i) {
                if (stringArray[n].compareToIgnoreCase(stringArray[i]) <= 0) continue;
                string = stringArray[n];
                stringArray[n] = stringArray[i];
                stringArray[i] = string;
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.actorList.add(stringArray[n]);
        }
        this.actorList.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                JapeFrame.this.suche = "";
            }

            public void focusLost(FocusEvent focusEvent) {
                JapeFrame.this.suche = "";
            }
        });
        this.actorList.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    JapeFrame.this.suche = "";
                    return;
                }
                if (keyEvent.getKeyCode() == 8) {
                    if (JapeFrame.this.suche.length() > 1) {
                        JapeFrame.this.suche = JapeFrame.this.suche.substring(0, JapeFrame.this.suche.length() - 1);
                    } else {
                        JapeFrame.this.suche = "";
                    }
                    return;
                }
                JapeFrame.this.suche = JapeFrame.this.suche + keyEvent.getKeyChar();
                JapeFrame.this.suche = JapeFrame.this.suche.toLowerCase();
                for (int i = 0; i < ((JapeFrame)JapeFrame.this).saveGame.actorCount; ++i) {
                    JapeFrame.this.vergleich = JapeFrame.this.saveGame.getActor(i).get("Nickname");
                    if (JapeFrame.this.suche.length() < JapeFrame.this.vergleich.length()) {
                        JapeFrame.this.vergleich = JapeFrame.this.vergleich.substring(0, JapeFrame.this.suche.length());
                    }
                    JapeFrame.this.vergleich = JapeFrame.this.vergleich.toLowerCase();
                    if (!JapeFrame.this.suche.equals(JapeFrame.this.vergleich)) continue;
                    JapeFrame.this.actorList.select(i);
                    JapeFrame.this.doSelectActor();
                    return;
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    public static void setcaption(String string) {
        feld.setTitle(string);
    }
}

